/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.BaseGondorBiome;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;

public class LamedonBiome
extends BaseGondorBiome {
    public LamedonBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.2f).func_205420_b(0.2f).func_205414_c(0.7f).func_205417_d(0.9f), major);
    }

    protected LamedonBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setGrass(11646287);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        super.setupSurface(config);
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.4, 0.07) > 0.35) {
                return top ? Blocks.field_196660_k.func_176223_P() : in;
            }
            return in;
        });
    }

    @Override
    protected void addBoulders() {
        super.addBoulders();
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 3, 16, 4);
    }

    protected int getLamedonBaseTreeRate() {
        return 0;
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithClusters(this, this.getLamedonBaseTreeRate(), 0.1f, TreeCluster.of(10, 20), LOTRBiomeFeatures.oak(), 5000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakBees(), 50, LOTRBiomeFeatures.oakFancyBees(), 10, LOTRBiomeFeatures.birch(), 500, LOTRBiomeFeatures.birchFancy(), 100, LOTRBiomeFeatures.birchBees(), 5, LOTRBiomeFeatures.birchFancyBees(), 1, LOTRBiomeFeatures.beech(), 500, LOTRBiomeFeatures.beechFancy(), 100, LOTRBiomeFeatures.beechBees(), 5, LOTRBiomeFeatures.beechFancyBees(), 1, LOTRBiomeFeatures.larch(), 3000, LOTRBiomeFeatures.aspen(), 3000, LOTRBiomeFeatures.apple(), 50, LOTRBiomeFeatures.pear(), 50, LOTRBiomeFeatures.appleBees(), 1, LOTRBiomeFeatures.pearBees(), 1);
        LOTRBiomeFeatures.addGrass(this, 8);
        LOTRBiomeFeatures.addDoubleGrass(this, 1);
        LOTRBiomeFeatures.addPlainsFlowers(this, 3, new Object[0]);
        LOTRBiomeFeatures.addDefaultDoubleFlowers(this, 1, new Object[0]);
        LOTRBiomeFeatures.addAthelasChance(this);
        LOTRBiomeFeatures.addWildPipeweedChance(this, 24);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
        this.addHorsesDonkeys(6);
        this.addExtraSheep(3);
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.LAMEDON;
    }

    public static class Hills
    extends LamedonBiome {
        public Hills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.6f).func_205420_b(0.9f).func_205414_c(0.6f).func_205417_d(0.7f), major);
            this.biomeColors.resetGrass();
        }

        @Override
        protected int getLamedonBaseTreeRate() {
            return 1;
        }

        @Override
        public LOTRBiomeBase getRiver() {
            return null;
        }
    }
}

