/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class LindonBiome
extends LOTRBiomeBase {
    public LindonBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.15f).func_205420_b(0.25f).func_205414_c(0.7f).func_205417_d(0.9f), major);
    }

    protected LindonBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setSky(9411050).setFog(15264767);
    }

    @Override
    protected void addStoneVariants() {
        LOTRBiomeFeatures.addAndesite(this);
    }

    @Override
    protected void addOres() {
        super.addOres();
        LOTRBiomeFeatures.addEdhelvirOre(this);
    }

    @Override
    protected void addBiomeSandSediments() {
        LOTRBiomeFeatures.addWhiteSandSediments(this);
    }

    protected final Object[] lindonTrees() {
        return new Object[]{LOTRBiomeFeatures.oak(), 1000, LOTRBiomeFeatures.oakFancy(), 250, LOTRBiomeFeatures.oakBees(), 1, LOTRBiomeFeatures.oakFancyBees(), 1, LOTRBiomeFeatures.birch(), 10000, LOTRBiomeFeatures.birchFancy(), 2000, LOTRBiomeFeatures.birchBees(), 10, LOTRBiomeFeatures.birchFancyBees(), 2, LOTRBiomeFeatures.beech(), 1000, LOTRBiomeFeatures.beechFancy(), 250, LOTRBiomeFeatures.beechBees(), 1, LOTRBiomeFeatures.beechFancyBees(), 1, LOTRBiomeFeatures.aspen(), 2000, LOTRBiomeFeatures.aspenLarge(), 1000, LOTRBiomeFeatures.apple(), 20, LOTRBiomeFeatures.pear(), 20, LOTRBiomeFeatures.appleBees(), 1, LOTRBiomeFeatures.pearBees(), 1};
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.05f, TreeCluster.of(10, 10), this.lindonTrees());
        LOTRBiomeFeatures.addGrass(this, 8);
        LOTRBiomeFeatures.addDoubleGrass(this, 1);
        LOTRBiomeFeatures.addPlainsFlowers(this, 3, new Object[0]);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
        this.addHorsesDonkeys();
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, ((Block)LOTRBlocks.LINDON_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.HIGH_ELVEN_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_180404_aQ.func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.HIGH_ELVEN_TORCH.get()).func_176223_P(), 1));
    }

    @Override
    public LOTRBiomeBase getShore() {
        return (LOTRBiomeBase)LOTRBiomes.WHITE_BEACH.get();
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.LINDON;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.HIGH_ELVEN;
    }

    public static class Woodlands
    extends LindonBiome {
        public Woodlands(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.2f).func_205420_b(0.5f).func_205414_c(0.7f).func_205417_d(1.0f), major);
        }

        @Override
        protected void addVegetation() {
            LOTRBiomeFeatures.addTrees(this, 6, 0.05f, this.lindonTrees());
            LOTRBiomeFeatures.addGrass(this, 10);
            LOTRBiomeFeatures.addDoubleGrass(this, 3);
            LOTRBiomeFeatures.addForestFlowers(this, 4, new Object[0]);
            LOTRBiomeFeatures.addDefaultDoubleFlowers(this, 1, new Object[0]);
        }

        @Override
        protected void addAnimals() {
            super.addAnimals();
            this.addDeer(3);
        }
    }
}

