/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class LoneLandsBiome
extends LOTRBiomeBase {
    public LoneLandsBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.15f).func_205420_b(0.4f).func_205414_c(0.6f).func_205417_d(0.5f), major);
    }

    protected LoneLandsBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setGrass(12565603);
    }

    @Override
    protected void addStoneVariants() {
        LOTRBiomeFeatures.addCommonGranite(this);
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 5, 32, 3);
    }

    protected final Object[] loneLandsTrees() {
        return new Object[]{LOTRBiomeFeatures.oak(), 10000, LOTRBiomeFeatures.oakFancy(), 3000, LOTRBiomeFeatures.oakBees(), 10, LOTRBiomeFeatures.oakFancyBees(), 3, LOTRBiomeFeatures.spruce(), 3000, LOTRBiomeFeatures.beech(), 1000, LOTRBiomeFeatures.beechFancy(), 500, LOTRBiomeFeatures.beechBees(), 1, LOTRBiomeFeatures.beechFancyBees(), 1, LOTRBiomeFeatures.birch(), 100, LOTRBiomeFeatures.birchFancy(), 50, LOTRBiomeFeatures.birchBees(), 1, LOTRBiomeFeatures.birchFancyBees(), 1, LOTRBiomeFeatures.maple(), 50, LOTRBiomeFeatures.mapleFancy(), 5, LOTRBiomeFeatures.mapleBees(), 1, LOTRBiomeFeatures.mapleFancyBees(), 1, LOTRBiomeFeatures.aspen(), 500, LOTRBiomeFeatures.aspenLarge(), 100, LOTRBiomeFeatures.apple(), 10, LOTRBiomeFeatures.pear(), 10, LOTRBiomeFeatures.appleBees(), 1, LOTRBiomeFeatures.pearBees(), 1};
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.2f, TreeCluster.of(12, 20), this.loneLandsTrees());
        LOTRBiomeFeatures.addGrass(this, 10);
        LOTRBiomeFeatures.addDoubleGrass(this, 6);
        LOTRBiomeFeatures.addPlainsFlowers(this, 3, new Object[0]);
        LOTRBiomeFeatures.addAthelasChance(this);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
        this.addHorsesDonkeys();
        this.addBears(2);
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, 2, ((Block)LOTRBlocks.RANGER_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.ARNOR_BRICK.get()).func_176223_P(), 4).func_227407_a_(((Block)LOTRBlocks.MOSSY_ARNOR_BRICK.get()).func_176223_P(), 1).func_227407_a_(((Block)LOTRBlocks.CRACKED_ARNOR_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_180407_aO.func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_150478_aa.func_176223_P(), 1));
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.LONE_LANDS;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.ARNOR.withRepair(0.6f);
    }

    public static class Hills
    extends LoneLandsBiome {
        public Hills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.7f).func_205420_b(1.0f).func_205414_c(0.6f).func_205417_d(0.7f), major);
            this.biomeColors.setGrass(11713120);
        }

        @Override
        protected void addStoneVariants() {
            super.addStoneVariants();
            LOTRBiomeFeatures.addAndesite(this);
            LOTRBiomeFeatures.addDiorite(this);
        }

        @Override
        protected void addVegetation() {
            LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.1f, TreeCluster.of(8, 30), this.loneLandsTrees());
            LOTRBiomeFeatures.addMoorsGrass(this, 6);
            LOTRBiomeFeatures.addMoorsDoubleGrass(this, 2);
            LOTRBiomeFeatures.addPlainsFlowers(this, 1, new Object[0]);
            LOTRBiomeFeatures.addAthelasChance(this);
        }

        @Override
        protected void addAnimals() {
            super.addAnimals();
            this.addWolves(2);
        }
    }
}

