/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.world.biome.Biome;

public class LongMarshesBiome
extends LOTRBiomeBase {
    private static final int LONG_MARSHES_WATER_COLOR = 8167049;

    public LongMarshesBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(-0.22f).func_205420_b(0.0f).func_205414_c(0.5f).func_205417_d(0.9f), 8167049, major);
        this.biomeColors.setSky(13230818).setFog(12112325).setFoggy(true).setWater(8167049);
    }

    @Override
    public float getStrengthOfAddedDepthNoise() {
        return 0.15f;
    }

    @Override
    public float getBiomeScaleSignificanceForChunkGen() {
        return 0.96f;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setMarsh(true);
    }

    @Override
    protected void addBiomeSandSediments() {
        LOTRBiomeFeatures.addQuagmire(this, 2);
    }

    @Override
    protected void addVegetation() {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oak(), 500, LOTRBiomeFeatures.oakFancy(), 100, LOTRBiomeFeatures.oakSwamp(), 1000, LOTRBiomeFeatures.oakShrub(), 3000, LOTRBiomeFeatures.oakDead(), 500, LOTRBiomeFeatures.spruce(), 500, LOTRBiomeFeatures.spruceDead(), 500, LOTRBiomeFeatures.fir(), 200, LOTRBiomeFeatures.pine(), 200};
        LOTRBiomeFeatures.addTreesBelowTreeline(this, 1, 0.5f, 63, weightedTrees);
        LOTRBiomeFeatures.addTreesAboveTreeline(this, 3, 0.5f, 64, weightedTrees);
        LOTRBiomeFeatures.addGrassWithFernsWithoutPrettyTypes(this, 6);
        LOTRBiomeFeatures.addDoubleGrassWithFernsWithoutPrettyTypes(this, 12);
        LOTRBiomeFeatures.addSwampFlowers(this, 2, new Object[0]);
        LOTRBiomeFeatures.addMoreMushroomsFreq(this, 3);
        LOTRBiomeFeatures.addWaterLilies(this, 4);
        LOTRBiomeFeatures.addSwampSeagrass(this);
        LOTRBiomeFeatures.addFallenLogs(this, 1);
    }

    @Override
    protected void addReeds() {
        super.addReeds();
        LOTRBiomeFeatures.addMoreSwampReeds(this);
        LOTRBiomeFeatures.addSwampRushes(this);
    }

    @Override
    protected void addAnimals() {
    }

    @Override
    public LOTRBiomeBase getRiver() {
        return null;
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.WILDERLAND;
    }
}

