/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.util.LOTRUtil;
import lotr.common.world.biome.ExtendedWeatherType;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;

public class LostladenBiome
extends LOTRBiomeBase {
    public LostladenBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.DESERT).func_205421_a(0.2f).func_205420_b(0.1f).func_205414_c(0.9f).func_205417_d(0.2f), major);
        this.biomeColors.setSky(15592678);
        this.biomeColors.setCloudCoverage(0.7f);
        this.biomeColors.setFog(15393237);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.4, 0.09) > 0.15) {
                return top ? Blocks.field_196660_k.func_176223_P() : in;
            }
            if (config.getNoise2(x, z, 0.4, 0.09) > 0.05) {
                return LOTRUtil.getCoordinateRandomModulo(x, 0, z, 5) == 0 ? Blocks.field_150322_A.func_176223_P() : Blocks.field_150354_m.func_176223_P();
            }
            if (config.getNoise3(x, z, 0.4, 0.09) > 0.05) {
                return LOTRUtil.getCoordinateRandomModulo(x, 0, z, 5) == 0 ? Blocks.field_150351_n.func_176223_P() : Blocks.field_150348_b.func_176223_P();
            }
            return in;
        });
    }

    @Override
    protected void addOres() {
        super.addOres();
        LOTRBiomeFeatures.addLapisOre(this);
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 3, 48, 3);
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150322_A.func_176223_P(), 1, 3, 48, 3);
    }

    @Override
    protected void addVegetation() {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oakDead(), 200, LOTRBiomeFeatures.oakDesert(), 1000};
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.02f, TreeCluster.of(8, 200), weightedTrees);
        LOTRBiomeFeatures.addGrassWithArid(this, 3);
        LOTRBiomeFeatures.addDoubleGrassWithArid(this, 1);
        LOTRBiomeFeatures.addDefaultFlowers(this, 0, new Object[0]);
        LOTRBiomeFeatures.addCactiAtSurfaceChance(this, 200);
        LOTRBiomeFeatures.addDeadBushAtSurfaceChance(this, 8);
    }

    @Override
    protected void addAnimals() {
    }

    @Override
    protected ExtendedWeatherType getExtendedWeather() {
        return ExtendedWeatherType.SANDSTORM;
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.LOSTLADEN;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.HARAD.withRepair(0.3f);
    }
}

