/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class LothlorienBiome
extends LOTRBiomeBase {
    public LothlorienBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.1f).func_205420_b(0.3f).func_205414_c(0.8f).func_205417_d(0.8f), major);
    }

    protected LothlorienBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setGrass(11527451);
        this.biomeColors.setFog(16770660);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setPodzol(false);
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (top) {
                double scale1 = 0.003;
                double roundFactor = 2.0;
                int xMod = x;
                int zMod = z;
                boolean adjDifferent = false;
                int noiseCentral = (int)((config.getNoise1(xMod, zMod, 0.003) + config.getNoise2(xMod, zMod, 0.003)) * 2.0);
                for (int i = -1; i <= 1; ++i) {
                    for (int k = -1; k <= 1; ++k) {
                        int noiseAdj;
                        if (i == 0 && k == 0 || (noiseAdj = (int)((config.getNoise1(xMod + i, zMod + k, 0.003) + config.getNoise2(xMod + i, zMod + k, 0.003)) * 2.0)) == noiseCentral) continue;
                        adjDifferent = true;
                    }
                }
                if (adjDifferent) {
                    return Blocks.field_185774_da.func_176223_P();
                }
            }
            return in;
        });
    }

    @Override
    protected void addOres() {
        super.addOres();
        LOTRBiomeFeatures.addEdhelvirOre(this);
    }

    @Override
    protected void addCobwebs() {
    }

    @Override
    protected void addBiomeSandSediments() {
        LOTRBiomeFeatures.addWhiteSandSediments(this);
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTrees(this, 3, 0.1f, LOTRBiomeFeatures.mallorn(), 3000, LOTRBiomeFeatures.mallornBees(), 30, LOTRBiomeFeatures.mallornBoughs(), 6000, LOTRBiomeFeatures.oak(), 3000, LOTRBiomeFeatures.oakFancy(), 500, LOTRBiomeFeatures.oakBees(), 30, LOTRBiomeFeatures.oakFancyBees(), 5, LOTRBiomeFeatures.larch(), 2000, LOTRBiomeFeatures.beech(), 1000, LOTRBiomeFeatures.beechFancy(), 200, LOTRBiomeFeatures.beechBees(), 10, LOTRBiomeFeatures.beechFancyBees(), 2, LOTRBiomeFeatures.aspen(), 1000, LOTRBiomeFeatures.aspenLarge(), 200, LOTRBiomeFeatures.lairelosse(), 500);
        LOTRBiomeFeatures.addGrass(this, 8);
        LOTRBiomeFeatures.addDoubleGrass(this, 2);
        LOTRBiomeFeatures.addForestFlowers(this, 6, LOTRBlocks.ELANOR.get(), 20, LOTRBlocks.NIPHREDIL.get(), 20);
        LOTRBiomeFeatures.addTreeTorches(this, 120, 60, 110, ((Block)LOTRBlocks.GOLD_MALLORN_WALL_TORCH.get()).func_176223_P(), ((Block)LOTRBlocks.BLUE_MALLORN_WALL_TORCH.get()).func_176223_P(), ((Block)LOTRBlocks.GREEN_MALLORN_WALL_TORCH.get()).func_176223_P(), ((Block)LOTRBlocks.SILVER_MALLORN_WALL_TORCH.get()).func_176223_P());
    }

    @Override
    protected void addLiquidSprings() {
        LOTRBiomeFeatures.addWaterSprings(this);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
        this.addHorsesDonkeys(4);
        this.addDeer(2);
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, ((Block)LOTRBlocks.GALADHRIM_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.MALLORN_PLANKS.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.MALLORN_FENCE.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.GOLD_MALLORN_TORCH.get()).func_176223_P(), 1).func_227407_a_(((Block)LOTRBlocks.BLUE_MALLORN_TORCH.get()).func_176223_P(), 1).func_227407_a_(((Block)LOTRBlocks.GREEN_MALLORN_TORCH.get()).func_176223_P(), 1).func_227407_a_(((Block)LOTRBlocks.SILVER_MALLORN_TORCH.get()).func_176223_P(), 1));
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.LOTHLORIEN;
    }

    public static class Eaves
    extends LothlorienBiome {
        public Eaves(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.8f).func_205417_d(0.8f), major);
        }

        @Override
        protected void addVegetation() {
            LOTRBiomeFeatures.addTrees(this, 2, 0.5f, LOTRBiomeFeatures.mallorn(), 500, LOTRBiomeFeatures.mallornBees(), 5, LOTRBiomeFeatures.mallornBoughs(), 100, LOTRBiomeFeatures.oak(), 3000, LOTRBiomeFeatures.oakFancy(), 500, LOTRBiomeFeatures.oakBees(), 30, LOTRBiomeFeatures.oakFancyBees(), 5, LOTRBiomeFeatures.larch(), 2000, LOTRBiomeFeatures.beech(), 1000, LOTRBiomeFeatures.beechFancy(), 200, LOTRBiomeFeatures.beechBees(), 10, LOTRBiomeFeatures.beechFancyBees(), 2, LOTRBiomeFeatures.aspen(), 1000, LOTRBiomeFeatures.aspenLarge(), 200);
            LOTRBiomeFeatures.addGrass(this, 10);
            LOTRBiomeFeatures.addDoubleGrass(this, 3);
            LOTRBiomeFeatures.addForestFlowers(this, 2, LOTRBlocks.ELANOR.get(), 10, LOTRBlocks.NIPHREDIL.get(), 10);
        }
    }
}

