/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;

public class MiddleEarthSurfaceConfig
implements ISurfaceBuilderConfig {
    private BlockState topMaterial;
    private BlockState fillerMaterial;
    private double fillerDepth = 5.0;
    private static final double DEFAULT_FILLER_DEPTH = 5.0;
    private BlockState underwaterMaterial;
    private List<SubSoilLayer> subSoilLayers = new ArrayList<SubSoilLayer>();
    private boolean rocky = true;
    private boolean podzol = true;
    private boolean marsh = false;
    protected static final PerlinNoiseGenerator MARSH_NOISE = new PerlinNoiseGenerator(new SharedSeedRandom(444L), 0, 0);
    private SurfaceNoiseMixer surfaceNoiseMixer = SurfaceNoiseMixer.DEFAULT;
    private UnderwaterNoiseMixer underwaterNoiseMixer = UnderwaterNoiseMixer.DEFAULT;
    private final PerlinNoiseGenerator noiseGen1 = new PerlinNoiseGenerator(new SharedSeedRandom(1954L), 0, 0);
    private final PerlinNoiseGenerator noiseGen2 = new PerlinNoiseGenerator(new SharedSeedRandom(10420914965337148L), 0, 0);
    private final PerlinNoiseGenerator noiseGen3 = new PerlinNoiseGenerator(new SharedSeedRandom(2274201084179107L), 0, 0);
    private final PerlinNoiseGenerator noiseGen4 = new PerlinNoiseGenerator(new SharedSeedRandom(259632637571778808L), 0, 0);
    private MountainTerrainProvider mountainTerrainProvider = MountainTerrainProvider.DEFAULT;

    public MiddleEarthSurfaceConfig(BlockState top, BlockState filler, BlockState underwater) {
        this.topMaterial = top;
        this.fillerMaterial = filler;
        this.underwaterMaterial = underwater;
    }

    public static MiddleEarthSurfaceConfig createDefault() {
        return new MiddleEarthSurfaceConfig(Blocks.field_196658_i.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150351_n.func_176223_P());
    }

    public BlockState func_204108_a() {
        return this.topMaterial;
    }

    public void setTop(BlockState state) {
        this.topMaterial = state;
    }

    public BlockState func_204109_b() {
        return this.fillerMaterial;
    }

    public void setFiller(BlockState state) {
        this.fillerMaterial = state;
    }

    public double getFillerDepth() {
        return this.fillerDepth;
    }

    public void setFillerDepth(double d) {
        this.fillerDepth = d;
    }

    public BlockState getUnderwaterMaterial() {
        return this.underwaterMaterial;
    }

    public void setUnderwater(BlockState state) {
        this.underwaterMaterial = state;
    }

    public Iterator<SubSoilLayer> getSubSoilLayers() {
        return this.subSoilLayers.iterator();
    }

    public void addSubSoilLayer(BlockState state, int depth) {
        this.addSubSoilLayer(state, depth, depth);
    }

    public void addSubSoilLayer(BlockState state, int min, int max) {
        this.subSoilLayers.add(new SubSoilLayer(state, min, max));
    }

    public void resetFillerDepthAndSubSoilLayers() {
        this.setFillerDepth(5.0);
        this.subSoilLayers.clear();
    }

    public boolean hasRockyTerrain() {
        return this.rocky;
    }

    public MiddleEarthSurfaceConfig setRockyTerrain(boolean flag) {
        this.rocky = flag;
        return this;
    }

    public boolean hasPodzol() {
        return this.podzol;
    }

    public MiddleEarthSurfaceConfig setPodzol(boolean flag) {
        this.podzol = flag;
        return this;
    }

    public boolean isMarsh() {
        return this.marsh;
    }

    public MiddleEarthSurfaceConfig setMarsh(boolean flag) {
        this.marsh = flag;
        return this;
    }

    public void setSurfaceNoiseMixer(SurfaceNoiseMixer mixer) {
        this.surfaceNoiseMixer = mixer;
    }

    public BlockState getSurfaceNoiseReplacement(int x, int z, BlockState in, boolean top, Random rand) {
        return this.surfaceNoiseMixer.getReplacement(x, z, in, top, rand);
    }

    public void setUnderwaterNoiseMixer(UnderwaterNoiseMixer mixer) {
        this.underwaterNoiseMixer = mixer;
    }

    public BlockState getUnderwaterNoiseReplacement(int x, int z, BlockState in, Random rand) {
        return this.underwaterNoiseMixer.getReplacement(x, z, in, rand);
    }

    public double getNoise1(int x, int z, double scale1) {
        return this.noiseGen1.func_215464_a((double)x * scale1, (double)z * scale1, false);
    }

    public double getNoise1(int x, int z, double scale1, double scale2) {
        return (this.noiseGen1.func_215464_a((double)x * scale1, (double)z * scale1, false) + this.noiseGen1.func_215464_a((double)x * scale2, (double)z * scale2, false)) / 2.0;
    }

    public double getNoise1(int x, int z, double scale1, double scale2, double scale3) {
        return (this.noiseGen1.func_215464_a((double)x * scale1, (double)z * scale1, false) + this.noiseGen1.func_215464_a((double)x * scale2, (double)z * scale2, false) + this.noiseGen1.func_215464_a((double)x * scale3, (double)z * scale3, false)) / 3.0;
    }

    public double getNoise2(int x, int z, double scale1) {
        return this.noiseGen2.func_215464_a((double)x * scale1, (double)z * scale1, false);
    }

    public double getNoise2(int x, int z, double scale1, double scale2) {
        return (this.noiseGen2.func_215464_a((double)x * scale1, (double)z * scale1, false) + this.noiseGen2.func_215464_a((double)x * scale2, (double)z * scale2, false)) / 2.0;
    }

    public double getNoise2(int x, int z, double scale1, double scale2, double scale3) {
        return (this.noiseGen2.func_215464_a((double)x * scale1, (double)z * scale1, false) + this.noiseGen2.func_215464_a((double)x * scale2, (double)z * scale2, false) + this.noiseGen2.func_215464_a((double)x * scale3, (double)z * scale3, false)) / 3.0;
    }

    public double getNoise3(int x, int z, double scale1) {
        return this.noiseGen3.func_215464_a((double)x * scale1, (double)z * scale1, false);
    }

    public double getNoise3(int x, int z, double scale1, double scale2) {
        return (this.noiseGen3.func_215464_a((double)x * scale1, (double)z * scale1, false) + this.noiseGen3.func_215464_a((double)x * scale2, (double)z * scale2, false)) / 2.0;
    }

    public double getNoise3(int x, int z, double scale1, double scale2, double scale3) {
        return (this.noiseGen3.func_215464_a((double)x * scale1, (double)z * scale1, false) + this.noiseGen3.func_215464_a((double)x * scale2, (double)z * scale2, false) + this.noiseGen3.func_215464_a((double)x * scale3, (double)z * scale3, false)) / 3.0;
    }

    public double getNoise4(int x, int z, double scale1) {
        return this.noiseGen4.func_215464_a((double)x * scale1, (double)z * scale1, false);
    }

    public double getNoise4(int x, int z, double scale1, double scale2) {
        return (this.noiseGen4.func_215464_a((double)x * scale1, (double)z * scale1, false) + this.noiseGen4.func_215464_a((double)x * scale2, (double)z * scale2, false)) / 2.0;
    }

    public double getNoise4(int x, int z, double scale1, double scale2, double scale3) {
        return (this.noiseGen4.func_215464_a((double)x * scale1, (double)z * scale1, false) + this.noiseGen4.func_215464_a((double)x * scale2, (double)z * scale2, false) + this.noiseGen4.func_215464_a((double)x * scale3, (double)z * scale3, false)) / 3.0;
    }

    public void setMountainTerrain(MountainTerrainProvider provider) {
        this.mountainTerrainProvider = provider;
    }

    public boolean hasMountainTerrain() {
        return this.mountainTerrainProvider != MountainTerrainProvider.DEFAULT;
    }

    public BlockState getMountainTerrain(int x, int z, int y, BlockState in, BlockState stone, boolean top, int rockDepth) {
        return this.mountainTerrainProvider.getReplacement(x, z, y, in, stone, top, rockDepth);
    }

    public static MiddleEarthSurfaceConfig deserialize(Dynamic<?> dyn) {
        BlockState top = dyn.get("top_material").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
        BlockState filler = dyn.get("under_material").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
        BlockState underwater = dyn.get("underwater_material").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
        MiddleEarthSurfaceConfig config = new MiddleEarthSurfaceConfig(top, filler, underwater);
        List subSoilLayers = dyn.get("sub_soil_layers").asList(dynElem -> {
            BlockState material = dynElem.get("sub_soil_material").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
            int minDepth = dynElem.get("sub_soil_depth_min").asInt(0);
            int maxDepth = dynElem.get("sub_soil_depth_max").asInt(0);
            return new SubSoilLayer(material, minDepth, maxDepth);
        });
        config.rocky = dyn.get("rocky").asBoolean(true);
        config.podzol = dyn.get("podzol").asBoolean(true);
        config.marsh = dyn.get("marsh").asBoolean(false);
        return config;
    }

    public static interface MountainTerrainProvider {
        public static final MountainTerrainProvider DEFAULT = (x, z, y, in, stone, top, rockDepth) -> stone;

        public BlockState getReplacement(int var1, int var2, int var3, BlockState var4, BlockState var5, boolean var6, int var7);
    }

    public static interface UnderwaterNoiseMixer {
        public static final UnderwaterNoiseMixer DEFAULT = (x, z, in, rand) -> in;

        public BlockState getReplacement(int var1, int var2, BlockState var3, Random var4);
    }

    public static interface SurfaceNoiseMixer {
        public static final SurfaceNoiseMixer DEFAULT = (x, z, in, top, rand) -> in;

        public BlockState getReplacement(int var1, int var2, BlockState var3, boolean var4, Random var5);
    }

    public static class SubSoilLayer {
        private final BlockState material;
        private final int minDepth;
        private final int maxDepth;

        public SubSoilLayer(BlockState state, int min, int max) {
            this.material = state;
            this.minDepth = min;
            this.maxDepth = max;
        }

        public BlockState getMaterial() {
            return this.material;
        }

        public int getDepth(Random rand) {
            return MathHelper.func_76136_a((Random)rand, (int)this.minDepth, (int)this.maxDepth);
        }
    }
}

