/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;

public class MirkwoodBiome
extends LOTRBiomeBase {
    private static final int MIRKWOOD_WATER_COLOR = 1708838;

    public MirkwoodBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.2f).func_205420_b(0.4f).func_205414_c(0.6f).func_205417_d(0.8f), 1708838, major);
    }

    protected MirkwoodBiome(Biome.Builder builder, int waterFogColor, boolean major) {
        super(builder, waterFogColor, major);
        this.biomeColors.setGrass(0x2B5B25).setFoliage(3096365).setFog(2774107).setFoggy(true).setWater(waterFogColor);
    }

    protected MirkwoodBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTrees(this, 10, 0.25f, LOTRBiomeFeatures.mirkOak(), 10000, LOTRBiomeFeatures.oakFancy(), 3000, LOTRBiomeFeatures.spruce(), 1000, LOTRBiomeFeatures.fir(), 1000, LOTRBiomeFeatures.pine(), 2000);
        LOTRBiomeFeatures.addGrassWithFernsWithoutPrettyTypes(this, 12);
        LOTRBiomeFeatures.addDoubleGrassWithFernsWithoutPrettyTypes(this, 6);
        LOTRBiomeFeatures.addForestFlowers(this, 1, new Object[0]);
        LOTRBiomeFeatures.addMoreMushroomsFreq(this, 2);
        LOTRBiomeFeatures.addMirkShroomsFreq(this, 1);
        LOTRBiomeFeatures.addFallenLogs(this, 2);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
        this.addDeer(3);
        this.addElk(8);
        this.addBears();
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.MIRKWOOD;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.MIRKWOOD_PATH.withRepair(0.9f);
    }

    public static class Northern
    extends MirkwoodBiome {
        public Northern(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.2f).func_205420_b(0.4f).func_205414_c(0.5f).func_205417_d(0.8f), major);
        }

        @Override
        protected void addVegetation() {
            LOTRBiomeFeatures.addTrees(this, 12, 0.1f, LOTRBiomeFeatures.greenOak(), 500, LOTRBiomeFeatures.greenOakBees(), 5, LOTRBiomeFeatures.mirkOak(), 50, LOTRBiomeFeatures.oak(), 500, LOTRBiomeFeatures.oakBees(), 5, LOTRBiomeFeatures.oakFancy(), 500, LOTRBiomeFeatures.oakFancyBees(), 5, LOTRBiomeFeatures.spruce(), 1000, LOTRBiomeFeatures.spruceThin(), 500, LOTRBiomeFeatures.spruceMega(), 200, LOTRBiomeFeatures.spruceThinMega(), 200, LOTRBiomeFeatures.larch(), 500, LOTRBiomeFeatures.fir(), 2000, LOTRBiomeFeatures.pine(), 2000, LOTRBiomeFeatures.aspen(), 500, LOTRBiomeFeatures.aspenLarge(), 100);
            LOTRBiomeFeatures.addGrassWithFerns(this, 12);
            LOTRBiomeFeatures.addDoubleGrassWithFerns(this, 6);
            LOTRBiomeFeatures.addForestFlowers(this, 2, new Object[0]);
            LOTRBiomeFeatures.addDefaultDoubleFlowers(this, 1, new Object[0]);
            LOTRBiomeFeatures.addMoreMushroomsFreq(this, 2);
            LOTRBiomeFeatures.addFallenLogs(this, 1);
            LOTRBiomeFeatures.addFoxBerryBushes(this);
        }

        @Override
        protected void addAnimals() {
            super.addAnimals();
            this.addFoxes();
        }
    }

    public static class Mountains
    extends MirkwoodBiome {
        public Mountains(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(1.5f).func_205420_b(1.5f).func_205414_c(0.28f).func_205417_d(0.9f), 1708838, major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setMountainTerrain((x, z, y, in, stone, top, rockDepth) -> {
                int snowLine = 150 - rockDepth;
                int stoneLine = snowLine - 40;
                if (top && y >= snowLine) {
                    return Blocks.field_196604_cC.func_176223_P();
                }
                if (y >= stoneLine && in.func_177230_c() != stone.func_177230_c()) {
                    return Blocks.field_150348_b.func_176223_P();
                }
                return in;
            });
        }

        @Override
        protected void addVegetation() {
            int treeline = 100;
            LOTRBiomeFeatures.addTreesBelowTreeline(this, 3, 0.25f, treeline, LOTRBiomeFeatures.mirkOak(), 200, LOTRBiomeFeatures.spruce(), 300, LOTRBiomeFeatures.fir(), 1000, LOTRBiomeFeatures.pine(), 300);
            LOTRBiomeFeatures.addGrassWithFernsWithoutPrettyTypes(this, 8);
            LOTRBiomeFeatures.addDoubleGrassWithFernsWithoutPrettyTypes(this, 4);
            LOTRBiomeFeatures.addForestFlowers(this, 1, new Object[0]);
            LOTRBiomeFeatures.addMoreMushroomsFreq(this, 2);
            LOTRBiomeFeatures.addMirkShroomsFreq(this, 1);
            LOTRBiomeFeatures.addFallenLogsBelowTreeline(this, 1, treeline);
        }

        @Override
        public LOTRBiomeBase getRiver() {
            return null;
        }
    }
}

