/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;

public class MistyMountainsBiome
extends LOTRBiomeBase {
    public MistyMountainsBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(2.0f).func_205420_b(2.0f).func_205414_c(0.2f).func_205417_d(0.5f), major);
    }

    protected MistyMountainsBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setSky(12241873);
    }

    protected boolean isFoothills() {
        return false;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        if (!this.isFoothills()) {
            config.setMountainTerrain((x, z, y, in, stone, top, rockDepth) -> {
                int snowLine = 120 - rockDepth;
                int stoneLine = snowLine - 30;
                if (top && y >= snowLine) {
                    return Blocks.field_196604_cC.func_176223_P();
                }
                if (y >= stoneLine && in.func_177230_c() != stone.func_177230_c()) {
                    return stone;
                }
                return in;
            });
        }
    }

    @Override
    protected void addStoneVariants() {
        LOTRBiomeFeatures.addGranite(this);
        LOTRBiomeFeatures.addDeepDiorite(this);
    }

    @Override
    protected void addOres() {
        super.addOres();
        LOTRBiomeFeatures.addMithrilOre(this, 0.25f);
        LOTRBiomeFeatures.addGlowstoneOre(this);
    }

    @Override
    protected void addVegetation() {
        Object[] treeParams = new Object[]{LOTRBiomeFeatures.spruce(), 400, LOTRBiomeFeatures.spruceThin(), 400, LOTRBiomeFeatures.spruceMega(), 100, LOTRBiomeFeatures.spruceThinMega(), 20, LOTRBiomeFeatures.fir(), 500, LOTRBiomeFeatures.pine(), 500, LOTRBiomeFeatures.larch(), 300};
        LOTRBiomeFeatures.addTrees(this, 0, 0.05f, treeParams);
        LOTRBiomeFeatures.addTreesBelowTreeline(this, 2, 0.1f, 100, treeParams);
        LOTRBiomeFeatures.addGrassWithoutPrettyTypes(this, 3);
        LOTRBiomeFeatures.addDoubleGrassWithoutPrettyTypes(this, 1);
        LOTRBiomeFeatures.addMountainsFlowers(this, 1, LOTRBlocks.DWARFWORT.get(), 1);
    }

    @Override
    protected void addLiquidSprings() {
        if (!this.isFoothills()) {
            LOTRBiomeFeatures.addWaterLavaSpringsReducedAboveground(this, 80, 0.15f);
        } else {
            super.addLiquidSprings();
        }
    }

    @Override
    protected void addAnimals() {
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.MISTY_MOUNTAINS;
    }

    public boolean hasMountainsMist() {
        return true;
    }

    public static class Foothills
    extends MistyMountainsBiome {
        public Foothills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(0.7f).func_205420_b(0.9f).func_205414_c(0.25f).func_205417_d(0.6f), major);
        }

        @Override
        protected boolean isFoothills() {
            return true;
        }

        @Override
        public boolean hasMountainsMist() {
            return false;
        }
    }
}

