/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.BaseMordorBiome;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;

public class MordorBiome
extends BaseMordorBiome {
    private static final int MORDOR_WATER_COLOR = 3884089;

    public MordorBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.DESERT).func_205421_a(0.3f).func_205420_b(0.5f).func_205414_c(1.5f).func_205417_d(0.0f), major);
    }

    protected MordorBiome(Biome.Builder builder, boolean major) {
        super(builder, 3884089, major);
        this.biomeColors.setGrass(7496538).setFoliage(5987138).setSky(0x605555).setClouds(6705223).setFog(6701621);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        super.setupSurface(config);
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.3, 0.06) > 0.1) {
                return ((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P();
            }
            if (config.getNoise2(x, z, 0.3, 0.06) > 0.5) {
                return Blocks.field_196660_k.func_176223_P();
            }
            if (config.getNoise3(x, z, 0.3, 0.06) > 0.2) {
                return ((Block)LOTRBlocks.MORDOR_DIRT.get()).func_176223_P();
            }
            if (config.getNoise4(x, z, 0.3, 0.06) > 0.25) {
                return ((Block)LOTRBlocks.MORDOR_GRAVEL.get()).func_176223_P();
            }
            return in;
        });
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, ((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P(), 1, 3, 60, 3);
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 2, 60, 3);
        LOTRBiomeFeatures.addBoulders(this, ((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P(), 0, 1, 12, 3);
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 0, 1, 24, 3);
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesBelowTreelineIncrease(this, 0, 0.025f, 5, 100, LOTRBiomeFeatures.charred(), 100, LOTRBiomeFeatures.oakDead(), 50, LOTRBiomeFeatures.oakDesert(), 20);
        LOTRBiomeFeatures.addGrassWithoutPrettyTypesWithoutThistles(this, 2);
        LOTRBiomeFeatures.addMordorMoss(this, 20);
        LOTRBiomeFeatures.addMordorGrass(this, 4);
        LOTRBiomeFeatures.addMordorThorns(this, 40);
        LOTRBiomeFeatures.addMorgulShrooms(this, 32);
    }

    public static class Mountains
    extends MordorBiome {
        public Mountains(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(2.0f).func_205420_b(2.0f).func_205414_c(1.5f).func_205417_d(0.0f), major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setRockyTerrain(false);
            config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
                if (config.getNoise1(x, z, 0.3, 0.06) > 0.0) {
                    return ((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P();
                }
                if (config.getNoise1(x, z, 0.3, 0.06) > 0.65) {
                    return Blocks.field_196660_k.func_176223_P();
                }
                if (config.getNoise2(x, z, 0.3, 0.06) > 0.2) {
                    return ((Block)LOTRBlocks.MORDOR_DIRT.get()).func_176223_P();
                }
                if (config.getNoise3(x, z, 0.3, 0.06) > 0.1) {
                    return ((Block)LOTRBlocks.MORDOR_GRAVEL.get()).func_176223_P();
                }
                return in;
            });
            config.setMountainTerrain((x, z, y, in, stone, top, rockDepth) -> {
                Block block;
                int stoneLine = 100 - rockDepth;
                if (y >= stoneLine && (block = in.func_177230_c()) != LOTRBlocks.MORDOR_ROCK.get() && block != LOTRBlocks.MORDOR_DIRT.get() && block != LOTRBlocks.MORDOR_GRAVEL.get()) {
                    return ((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P();
                }
                return in;
            });
        }
    }
}

