/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;

public class NindalfBiome
extends LOTRBiomeBase {
    private static final int NINDALF_WATER_COLOR = 8362365;

    public NindalfBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(-0.22f).func_205420_b(0.0f).func_205414_c(0.5f).func_205417_d(1.0f), 8362365, major);
        this.biomeColors.setGrass(6519879).setFoliage(6976836).setSky(9740163).setClouds(8687218).setFog(7500388).setWater(8362365);
    }

    @Override
    public float getStrengthOfAddedDepthNoise() {
        return 0.15f;
    }

    @Override
    public float getBiomeScaleSignificanceForChunkGen() {
        return 0.96f;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setMarsh(true);
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.4, 0.07) > 0.45) {
                return top ? Blocks.field_196660_k.func_176223_P() : in;
            }
            return in;
        });
    }

    @Override
    protected void addBiomeSandSediments() {
        LOTRBiomeFeatures.addQuagmire(this, 2);
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 3, 24, 3);
    }

    @Override
    protected void addVegetation() {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oak(), 200, LOTRBiomeFeatures.oakSwamp(), 600, LOTRBiomeFeatures.oakShrub(), 10000, LOTRBiomeFeatures.oakDead(), 500, LOTRBiomeFeatures.spruce(), 1500, LOTRBiomeFeatures.spruceDead(), 1000};
        LOTRBiomeFeatures.addTreesBelowTreeline(this, 1, 0.5f, 63, weightedTrees);
        LOTRBiomeFeatures.addTreesAboveTreeline(this, 2, 0.5f, 64, weightedTrees);
        LOTRBiomeFeatures.addGrassWithFernsWithoutPrettyTypes(this, 12);
        LOTRBiomeFeatures.addDoubleGrassWithFernsWithoutPrettyTypes(this, 10);
        LOTRBiomeFeatures.addSwampFlowers(this, 1, new Object[0]);
        LOTRBiomeFeatures.addDeadBushAtSurfaceChance(this, 4);
        LOTRBiomeFeatures.addMoreMushroomsFreq(this, 3);
        LOTRBiomeFeatures.addWaterLilies(this, 3);
        LOTRBiomeFeatures.addSwampSeagrass(this);
        LOTRBiomeFeatures.addFallenLogs(this, 2);
    }

    @Override
    protected void addReeds() {
        super.addReeds();
        LOTRBiomeFeatures.addSwampRushes(this);
    }

    @Override
    protected void addAnimals() {
    }

    @Override
    public LOTRBiomeBase getRiver() {
        return null;
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.NINDALF;
    }
}

