/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.awt.Color;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NorthlandsBiome
extends LOTRBiomeBase {
    private static final PerlinNoiseGenerator noiseGenTundraGrass = new PerlinNoiseGenerator(new SharedSeedRandom(2971944500256852478L), 0, 0);

    public NorthlandsBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.ICY).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.1f).func_205417_d(0.3f), major);
    }

    protected NorthlandsBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.3, 0.07) > 0.4) {
                return top ? Blocks.field_196660_k.func_176223_P() : in;
            }
            if (config.getNoise2(x, z, 0.3, 0.07) > 0.6) {
                return Blocks.field_150348_b.func_176223_P();
            }
            return in;
        });
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 3, 80, 1);
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 3, 80, 3);
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTrees(this, 0, 0.04f, LOTRBiomeFeatures.spruce(), 600, LOTRBiomeFeatures.spruceThin(), 400, LOTRBiomeFeatures.spruceDead(), 1000, LOTRBiomeFeatures.pine(), 500, LOTRBiomeFeatures.fir(), 1000, LOTRBiomeFeatures.maple(), 100, LOTRBiomeFeatures.beech(), 100);
        LOTRBiomeFeatures.addMoorsGrass(this, 4);
        LOTRBiomeFeatures.addMoorsDoubleGrass(this, 1);
        LOTRBiomeFeatures.addBorealFlowers(this, 2, new Object[0]);
        LOTRBiomeFeatures.addTundraBushes(this, 2, (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_((BlockState)Blocks.field_196645_X.func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), 3).func_227407_a_((BlockState)((Block)LOTRBlocks.MAPLE_LEAVES.get()).func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), 3).func_227407_a_((BlockState)((Block)LOTRBlocks.BEECH_LEAVES.get()).func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), 3));
    }

    @Override
    protected void addAnimals() {
        this.addWolves(2);
        this.addDeer(1);
        this.addElk(2);
        this.addBears(3);
        this.addFoxes(2);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int func_225528_a_(double x, double z) {
        int color1 = 10708034;
        int color2 = 13747522;
        double d1 = noiseGenTundraGrass.func_215464_a(x * 0.002, z * 0.002, false);
        double d2 = noiseGenTundraGrass.func_215464_a(x * 0.04, z * 0.04, false);
        float noise = (float)MathHelper.func_151237_a((double)(d1 + (d2 *= 0.4)), (double)-2.0, (double)2.0);
        noise += 2.0f;
        noise /= 4.0f;
        float[] rgb1 = new Color(color1).getColorComponents(null);
        float[] rgb2 = new Color(color2).getColorComponents(null);
        float[] rgbNoise = new float[rgb1.length];
        for (int l = 0; l < rgbNoise.length; ++l) {
            rgbNoise[l] = rgb1[l] + (rgb2[l] - rgb1[l]) * noise;
        }
        return new Color(rgbNoise[0], rgbNoise[1], rgbNoise[2]).getRGB();
    }

    public boolean func_201850_b(IWorldReader world, BlockPos pos) {
        return super.func_201850_b(world, pos) && this.isTundraSnowy(pos);
    }

    protected boolean isTundraSnowy(BlockPos pos) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        double d1 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.002, (double)z * 0.002, false);
        double d2 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.05, (double)z * 0.05, false);
        double d3 = SNOW_VARIETY_NOISE.func_215464_a((double)x * 0.3, (double)z * 0.3, false);
        return d1 + (d2 *= 0.3) + (d3 *= 0.3) > 0.8;
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.NORTHLANDS;
    }

    public static class Forest
    extends NorthlandsBiome {
        public Forest(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.FOREST).func_205421_a(0.1f).func_205420_b(0.5f).func_205414_c(0.1f).func_205417_d(0.7f), major);
        }

        @Override
        protected void addVegetation() {
            LOTRBiomeFeatures.addTrees(this, 2, 0.5f, LOTRBiomeFeatures.spruce(), 2000, LOTRBiomeFeatures.spruceThin(), 1000, LOTRBiomeFeatures.spruceDead(), 500, LOTRBiomeFeatures.pine(), 2000, LOTRBiomeFeatures.fir(), 2000);
            LOTRBiomeFeatures.addMoorsGrassWithFerns(this, 8);
            LOTRBiomeFeatures.addMoorsDoubleGrassWithFerns(this, 2);
            LOTRBiomeFeatures.addBorealFlowers(this, 2, new Object[0]);
            LOTRBiomeFeatures.addSparseFoxBerryBushes(this);
        }

        @Override
        protected void addAnimals() {
            super.addAnimals();
        }
    }
}

