/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class NurnBiome
extends LOTRBiomeBase {
    private static final int NURN_WATER_COLOR = 4413266;

    public NurnBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.8f).func_205417_d(0.5f), major);
    }

    protected NurnBiome(Biome.Builder builder, boolean major) {
        super(builder, 4413266, major);
        this.biomeColors.setGrass(10068025).setFoliage(7504951).setSky(10404589).setClouds(9342083).setWater(4413266);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setFillerDepth(2.0);
        config.addSubSoilLayer(((Block)LOTRBlocks.MORDOR_DIRT.get()).func_176223_P(), 3);
        config.addSubSoilLayer(((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P(), 1000);
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise2(x, z, 0.4, 0.08) > 0.4) {
                return top ? Blocks.field_196660_k.func_176223_P() : in;
            }
            return in;
        });
    }

    @Override
    protected void addDirtGravel() {
        LOTRBiomeFeatures.addMordorDirtGravel(this);
    }

    @Override
    protected void addStoneVariants() {
    }

    @Override
    protected void addOres() {
        LOTRBiomeFeatures.addMordorOres(this);
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, ((Block)LOTRBlocks.MORDOR_ROCK.get()).func_176223_P(), 1, 3, 40, 4);
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 4, 60, 3);
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.25f, TreeCluster.of(6, 30), LOTRBiomeFeatures.oak(), 5000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakDesert(), 5000, LOTRBiomeFeatures.oakDead(), 2000, LOTRBiomeFeatures.cedar(), 1000, LOTRBiomeFeatures.charred(), 2000);
        LOTRBiomeFeatures.addGrass(this, 6);
        LOTRBiomeFeatures.addDoubleGrass(this, 2);
        LOTRBiomeFeatures.addDefaultFlowers(this, 1, new Object[0]);
        LOTRBiomeFeatures.addMordorGrass(this, 2);
        LOTRBiomeFeatures.addMordorThorns(this, 200);
    }

    @Override
    protected void addReeds() {
        LOTRBiomeFeatures.addReedsWithDriedChance(this, 0.6f);
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, ((Block)LOTRBlocks.MORDOR_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.MORDOR_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.MORDOR_BRICK_WALL.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.ORC_TORCH.get()).func_176223_P(), 1));
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.NURN;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.NURN_PATH;
    }

    public static class Marshes
    extends NurnBiome {
        public Marshes(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(-0.22f).func_205420_b(0.0f).func_205414_c(0.7f).func_205417_d(0.8f), major);
            this.biomeColors.setGrass(8291139);
        }

        @Override
        public float getStrengthOfAddedDepthNoise() {
            return 0.15f;
        }

        @Override
        public float getBiomeScaleSignificanceForChunkGen() {
            return 0.96f;
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setMarsh(true);
        }

        @Override
        protected void addBiomeSandSediments() {
            LOTRBiomeFeatures.addQuagmire(this, 1);
        }

        @Override
        protected void addVegetation() {
            Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oak(), 500, LOTRBiomeFeatures.oakFancy(), 100, LOTRBiomeFeatures.oakSwamp(), 1000, LOTRBiomeFeatures.oakDead(), 1500, LOTRBiomeFeatures.oakShrub(), 6000};
            LOTRBiomeFeatures.addTreesBelowTreeline(this, 2, 0.5f, 63, weightedTrees);
            LOTRBiomeFeatures.addTreesAboveTreeline(this, 3, 0.5f, 64, weightedTrees);
            LOTRBiomeFeatures.addGrassWithFernsWithoutPrettyTypes(this, 10);
            LOTRBiomeFeatures.addDoubleGrassWithFernsWithoutPrettyTypes(this, 10);
            LOTRBiomeFeatures.addSwampFlowers(this, 2, new Object[0]);
            LOTRBiomeFeatures.addMoreMushroomsFreq(this, 4);
            LOTRBiomeFeatures.addSwampSeagrass(this);
            LOTRBiomeFeatures.addFallenLogs(this, 2);
        }

        @Override
        protected void addReeds() {
            super.addReeds();
            LOTRBiomeFeatures.addMoreSwampReeds(this);
            LOTRBiomeFeatures.addSwampRushes(this);
        }

        @Override
        protected void addAnimals() {
        }

        @Override
        protected void addStructures() {
        }

        @Override
        public LOTRBiomeBase getRiver() {
            return null;
        }
    }

    public static class Sea
    extends NurnBiome {
        public Sea(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.OCEAN).func_205421_a(-1.0f).func_205420_b(0.3f).func_205414_c(0.8f).func_205417_d(0.5f), major);
        }

        @Override
        public LOTRBiomeBase getRiver() {
            return null;
        }
    }
}

