/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.BaseGondorBiome;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;

public class PelargirBiome
extends BaseGondorBiome {
    public PelargirBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.08f).func_205420_b(0.2f).func_205414_c(1.0f).func_205417_d(1.0f), major);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        super.setupSurface(config);
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            double noise1 = config.getNoise1(x, (int)((double)z * 4.0), 0.015);
            double noise2 = config.getNoise1(x, (int)((double)z * 2.333), 0.3);
            if (noise1 + (noise2 *= 0.4) > 0.7) {
                return ((Block)LOTRBlocks.WHITE_SAND.get()).func_176223_P();
            }
            return in;
        });
    }

    @Override
    protected void addBiomeSandSediments() {
        LOTRBiomeFeatures.addWhiteSandSediments(this);
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, ((Block)LOTRBlocks.WHITE_SANDSTONE.get()).func_176223_P(), 1, 3, 24, 3);
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.05f, TreeCluster.of(6, 50), LOTRBiomeFeatures.oak(), 5000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakBees(), 50, LOTRBiomeFeatures.oakFancyBees(), 10, LOTRBiomeFeatures.birch(), 1000, LOTRBiomeFeatures.birchFancy(), 500, LOTRBiomeFeatures.birchBees(), 10, LOTRBiomeFeatures.birchFancyBees(), 5, LOTRBiomeFeatures.cypress(), 5000, LOTRBiomeFeatures.cedar(), 4000, LOTRBiomeFeatures.cedarLarge(), 500);
        LOTRBiomeFeatures.addGrass(this, 8);
        LOTRBiomeFeatures.addDoubleGrass(this, 1);
        LOTRBiomeFeatures.addPlainsFlowers(this, 4, LOTRBlocks.MALLOS.get(), 50);
        LOTRBiomeFeatures.addAthelasChance(this);
        LOTRBiomeFeatures.addWildPipeweedChance(this, 24);
    }

    @Override
    protected void addReeds() {
        super.addReeds();
        LOTRBiomeFeatures.addSugarCane(this);
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.LEBENNIN;
    }

    @Override
    public LOTRBiomeBase getShore() {
        return (LOTRBiomeBase)LOTRBiomes.WHITE_BEACH.get();
    }
}

