/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.ArrayList;
import java.util.List;
import lotr.common.LOTRMod;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.gen.feature.LatitudeBasedFeatureConfig;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SeaBiome
extends LOTRBiomeBase {
    private final PerlinNoiseGenerator iceNoiseGen = new PerlinNoiseGenerator(new SharedSeedRandom(5231241491057810726L), 0, 0);
    private List<Biome.SpawnListEntry> coldWaterSpawns;
    private List<Biome.SpawnListEntry> normalWaterSpawns;
    private List<Biome.SpawnListEntry> tropicalWaterSpawns;

    public SeaBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.OCEAN).func_205421_a(-1.5f).func_205420_b(0.1f).func_205414_c(0.7f).func_205417_d(0.9f), major);
    }

    protected SeaBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setUnderwaterNoiseMixer((x, z, in, rand) -> {
            double noiseAvg;
            double noiseNorm;
            double sandProgressF = MapSettingsManager.serverInstance().getCurrentLoadedMap().getWaterLatitudes().getSandyStartToFullProgress(z);
            boolean sandy = false;
            sandy = sandProgressF <= 0.0 ? false : (sandProgressF >= 1.0 ? true : (noiseNorm = ((noiseAvg = config.getNoise1(x, z, 0.1, 0.03)) + 1.0) / 2.0) < sandProgressF);
            return sandy ? Blocks.field_150354_m.func_176223_P() : Blocks.field_150351_n.func_176223_P();
        });
    }

    @Override
    protected void addFeatures() {
        super.addFeatures();
        this.addIcebergs();
    }

    protected void addIcebergs() {
        LOTRBiomeFeatures.addIcebergs(this);
        LOTRBiomeFeatures.addBlueIcePatches(this);
    }

    @Override
    protected void addCarvers() {
        LOTRBiomeFeatures.addSeaCarvers(this);
    }

    @Override
    protected void addStoneVariants() {
    }

    @Override
    protected void addOres() {
        super.addOres();
        LOTRBiomeFeatures.addExtraSalt(this, 8, 4, 64);
        LOTRBiomeFeatures.addSaltInSand(this, 8, 1, 56, 80);
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithLatitudeConfig(this, LatitudeBasedFeatureConfig.LatitudeConfiguration.ofInverted(LatitudeBasedFeatureConfig.LatitudeValuesType.ICE).min(0.75f), 1, 0.1f, LOTRBiomeFeatures.oak(), 10000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.birch(), 1000, LOTRBiomeFeatures.birchFancy(), 100, LOTRBiomeFeatures.beech(), 500, LOTRBiomeFeatures.beechFancy(), 50, LOTRBiomeFeatures.apple(), 30, LOTRBiomeFeatures.pear(), 30);
        LOTRBiomeFeatures.addTreesWithLatitudeConfig(this, LatitudeBasedFeatureConfig.LatitudeConfiguration.of(LatitudeBasedFeatureConfig.LatitudeValuesType.ICE), 0, 0.25f, LOTRBiomeFeatures.spruce(), 600, LOTRBiomeFeatures.spruceThin(), 400, LOTRBiomeFeatures.spruceDead(), 2000, LOTRBiomeFeatures.fir(), 400);
        LOTRBiomeFeatures.addGrass(this, 6);
        LOTRBiomeFeatures.addDoubleGrass(this, 1);
        LOTRBiomeFeatures.addDefaultFlowers(this, 2, new Object[0]);
        LOTRBiomeFeatures.addSeagrass(this, 48, 0.4);
        LOTRBiomeFeatures.addExtraUnderwaterSeagrass(this);
        LOTRBiomeFeatures.addKelp(this);
        LOTRBiomeFeatures.addCoral(this);
        LOTRBiomeFeatures.addSeaPickles(this);
        LOTRBiomeFeatures.addSponges(this);
    }

    @Override
    public List<Biome.SpawnListEntry> getSpawnsAtLocation(EntityClassification creatureType, IWorld world, BlockPos pos) {
        if (creatureType == EntityClassification.WATER_CREATURE) {
            int z = pos.func_177952_p();
            double iceProgressF = MapSettingsManager.sidedInstance((IWorldReader)world).getCurrentLoadedMap().getWaterLatitudes().getIceStartToFullProgress(z);
            double coralProgressF = MapSettingsManager.sidedInstance((IWorldReader)world).getCurrentLoadedMap().getWaterLatitudes().getCoralStartToFullProgress(z);
            if (iceProgressF > 0.0 && (double)world.func_201674_k().nextFloat() < iceProgressF) {
                return this.coldWaterSpawns;
            }
            if (coralProgressF > 0.0 && (double)world.func_201674_k().nextFloat() < coralProgressF) {
                return this.tropicalWaterSpawns;
            }
            return this.normalWaterSpawns;
        }
        return super.getSpawnsAtLocation(creatureType, world, pos);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
        this.func_76747_a(EntityClassification.CREATURE).clear();
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200737_ac, 6, 4, 4));
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_200786_Z, 2, 1, 2));
        this.coldWaterSpawns = new ArrayList<Biome.SpawnListEntry>();
        this.coldWaterSpawns.add(new Biome.SpawnListEntry(EntityType.field_200749_ao, 3, 1, 4));
        this.coldWaterSpawns.add(new Biome.SpawnListEntry(EntityType.field_203780_j, 15, 3, 6));
        this.coldWaterSpawns.add(new Biome.SpawnListEntry(EntityType.field_203778_ae, 15, 1, 5));
        this.normalWaterSpawns = new ArrayList<Biome.SpawnListEntry>();
        this.normalWaterSpawns.add(new Biome.SpawnListEntry(EntityType.field_200749_ao, 1, 1, 4));
        this.normalWaterSpawns.add(new Biome.SpawnListEntry(EntityType.field_203780_j, 10, 3, 6));
        this.normalWaterSpawns.add(new Biome.SpawnListEntry(EntityType.field_205137_n, 1, 1, 2));
        this.tropicalWaterSpawns = new ArrayList<Biome.SpawnListEntry>();
        this.tropicalWaterSpawns.add(new Biome.SpawnListEntry(EntityType.field_200749_ao, 10, 4, 4));
        this.tropicalWaterSpawns.add(new Biome.SpawnListEntry(EntityType.field_203779_Z, 15, 1, 3));
        this.tropicalWaterSpawns.add(new Biome.SpawnListEntry(EntityType.field_204262_at, 25, 8, 8));
        this.tropicalWaterSpawns.add(new Biome.SpawnListEntry(EntityType.field_205137_n, 2, 1, 2));
    }

    @Override
    public LOTRBiomeBase getRiver() {
        return null;
    }

    public boolean func_201854_a(IWorldReader world, BlockPos pos, boolean mustBeAtEdge) {
        if (this.isSeaFrozen(world, pos) && pos.func_177956_o() >= 0 && pos.func_177956_o() < world.func_201675_m().getHeight() && world.func_226658_a_(LightType.BLOCK, pos) < 10) {
            BlockState state = world.func_180495_p(pos);
            IFluidState fluid = world.func_204610_c(pos);
            if (fluid.func_206886_c() == Fluids.field_204546_a && state.func_177230_c() instanceof FlowingFluidBlock) {
                boolean surrounded;
                if (!mustBeAtEdge) {
                    return true;
                }
                boolean bl = surrounded = world.func_201671_F(pos.func_177976_e()) && world.func_201671_F(pos.func_177974_f()) && world.func_201671_F(pos.func_177978_c()) && world.func_201671_F(pos.func_177968_d());
                if (!surrounded) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_201850_b(IWorldReader world, BlockPos pos) {
        BlockState state;
        return this.isSeaFrozen(world, pos) && pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && world.func_226658_a_(LightType.BLOCK, pos) < 10 && (state = world.func_180495_p(pos)).isAir((IBlockReader)world, pos) && Blocks.field_150433_aE.func_176223_P().func_196955_c(world, pos);
    }

    public boolean isSeaFrozen(IWorldReader world, BlockPos pos) {
        double noise2;
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        float iceProgressF = this.getIceLatitudeLevel(world, z);
        if (iceProgressF <= 0.0f) {
            return false;
        }
        if (iceProgressF >= 1.0f) {
            return true;
        }
        double noise1 = this.iceNoiseGen.func_215464_a((double)x * 0.1, (double)z * 0.1, false);
        double noiseAvg = (noise1 + (noise2 = this.iceNoiseGen.func_215464_a((double)x * 0.03, (double)z * 0.03, false))) / 2.0;
        double noiseNorm = (noiseAvg + 1.0) / 2.0;
        return noiseNorm < (double)iceProgressF;
    }

    private float getIceLatitudeLevel(IWorldReader world, int z) {
        return MapSettingsManager.sidedInstance(world).getCurrentLoadedMap().getWaterLatitudes().getIceStartToFullProgress(z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int func_225528_a_(double x, double z) {
        if (this.biomeColors.hasGrass()) {
            return super.func_225528_a_(x, z);
        }
        float adjustedTemp = this.getAdjustedTemperatureForGrassAndFoliage((IWorldReader)LOTRMod.proxy.getClientWorld(), (int)z);
        adjustedTemp = MathHelper.func_76131_a((float)adjustedTemp, (float)0.0f, (float)1.0f);
        float downfall = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return GrassColors.func_77480_a((double)adjustedTemp, (double)downfall);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int func_225527_a_() {
        if (this.biomeColors.hasFoliage()) {
            return super.func_225527_a_();
        }
        float adjustedTemp = this.getAdjustedTemperatureForGrassAndFoliage((IWorldReader)LOTRMod.proxy.getClientWorld(), (int)LOTRMod.proxy.getClientPlayer().func_226281_cx_());
        float downfall = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return GrassColors.func_77480_a((double)adjustedTemp, (double)downfall);
    }

    private float getAdjustedTemperatureForGrassAndFoliage(IWorldReader world, int z) {
        float iceF = this.getIceLatitudeLevel(world, z);
        float adjustedTemp = MathHelper.func_219799_g((float)iceF, (float)this.func_185353_n(), (float)0.0f);
        return MathHelper.func_76131_a((float)adjustedTemp, (float)0.0f, (float)1.0f);
    }

    @Override
    public float getTemperatureForSnowWeatherRendering(IWorld world, BlockPos pos) {
        if (this.getIceLatitudeLevel((IWorldReader)world, pos.func_177952_p()) > 0.25f) {
            return 0.0f;
        }
        return super.getTemperatureForSnowWeatherRendering(world, pos);
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.SEA;
    }

    public static class WhiteBeach
    extends Beach {
        public WhiteBeach(boolean major) {
            super(major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            config.setTop(((Block)LOTRBlocks.WHITE_SAND.get()).func_176223_P());
            config.setFiller(((Block)LOTRBlocks.WHITE_SAND.get()).func_176223_P());
            config.setUnderwater(((Block)LOTRBlocks.WHITE_SAND.get()).func_176223_P());
        }

        @Override
        protected void addBiomeSandSediments() {
            LOTRBiomeFeatures.addWhiteSandSediments(this);
        }
    }

    public static class Beach
    extends SeaBiome {
        public Beach(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.BEACH).func_205421_a(-0.1f).func_205420_b(0.03f).func_205414_c(0.8f).func_205417_d(0.7f), major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            config.setTop(Blocks.field_150354_m.func_176223_P());
            config.setFiller(Blocks.field_150354_m.func_176223_P());
            config.setUnderwater(Blocks.field_150354_m.func_176223_P());
        }

        @Override
        protected void addIcebergs() {
        }

        @Override
        protected void addVegetation() {
            super.addVegetation();
            LOTRBiomeFeatures.addDriftwood(this, 12);
        }

        @Override
        protected void addAnimals() {
            super.addAnimals();
            this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_203099_aq, 10, 2, 5));
        }
    }

    public static class WesternIsles
    extends Island {
        public WesternIsles(boolean major) {
            super(major);
        }

        @Override
        protected void addIcebergs() {
        }

        @Override
        protected void addStoneVariants() {
            LOTRBiomeFeatures.addAndesite(this);
        }

        @Override
        public WaypointRegion getWaypointRegion() {
            return WaypointRegion.WESTERN_ISLES;
        }
    }

    public static class Island
    extends SeaBiome {
        public Island(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.OCEAN).func_205421_a(0.0f).func_205420_b(0.3f).func_205414_c(0.7f).func_205417_d(0.9f), major);
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
                if (config.getNoise1(x, z, 0.4, 0.09) > 0.7) {
                    return top ? Blocks.field_150351_n.func_176223_P() : in;
                }
                if (config.getNoise2(x, z, 0.4, 0.09) > 0.3) {
                    return Blocks.field_150348_b.func_176223_P();
                }
                return in;
            });
        }

        @Override
        protected void addIcebergs() {
        }

        @Override
        protected void addBoulders() {
            LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 1, 2, 3);
        }
    }
}

