/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.util.LOTRUtil;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class ShireBiome
extends LOTRBiomeBase {
    public ShireBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.15f).func_205420_b(0.3f).func_205414_c(0.8f).func_205417_d(0.7f), major);
    }

    protected ShireBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setGrass(8111137);
    }

    @Override
    protected void addStoneVariants() {
        LOTRBiomeFeatures.addCommonGranite(this);
    }

    protected final Object[] shireTrees() {
        return new Object[]{LOTRBiomeFeatures.oak(), 10000, LOTRBiomeFeatures.oakFancy(), 4000, LOTRBiomeFeatures.oakBees(), 100, LOTRBiomeFeatures.oakFancyBees(), 40, LOTRBiomeFeatures.birch(), 250, LOTRBiomeFeatures.birchFancy(), 100, LOTRBiomeFeatures.birchBees(), 2, LOTRBiomeFeatures.birchFancyBees(), 1, LOTRBiomeFeatures.aspen(), 500, LOTRBiomeFeatures.aspenLarge(), 100, LOTRBiomeFeatures.apple(), 50, LOTRBiomeFeatures.appleBees(), 1, LOTRBiomeFeatures.pear(), 50, LOTRBiomeFeatures.pearBees(), 1, LOTRBiomeFeatures.cherry(), 20, LOTRBiomeFeatures.cherryBees(), 1};
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.2f, TreeCluster.of(10, 6), this.shireTrees());
        LOTRBiomeFeatures.addShireGrass(this, 8);
        LOTRBiomeFeatures.addPlainsFlowers(this, 3, new Object[0]);
        LOTRBiomeFeatures.addDefaultDoubleFlowers(this, 1, new Object[0]);
        LOTRBiomeFeatures.addSunflowers(this, 6);
        LOTRBiomeFeatures.addWildPipeweedChance(this, 6);
    }

    @Override
    protected void addLiquidSprings() {
        LOTRBiomeFeatures.addWaterSprings(this);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
        this.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(EntityType.field_220356_B, 5, 2, 4));
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, ((Block)LOTRBlocks.HOBBIT_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.PINE_PLANKS.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.PINE_FENCE.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_150478_aa.func_176223_P(), 1));
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.SHIRE;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.PATH.withStandardHedge();
    }

    public static class Marshes
    extends ShireBiome {
        public Marshes(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(-0.22f).func_205420_b(0.0f).func_205414_c(0.8f).func_205417_d(1.2f), major);
            this.biomeColors.resetGrass();
        }

        @Override
        public float getStrengthOfAddedDepthNoise() {
            return 0.15f;
        }

        @Override
        public float getBiomeScaleSignificanceForChunkGen() {
            return 0.96f;
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setMarsh(true);
        }

        @Override
        protected void addBiomeSandSediments() {
            LOTRBiomeFeatures.addQuagmire(this, 1);
        }

        @Override
        protected void addVegetation() {
            Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oak(), 500, LOTRBiomeFeatures.oakFancy(), 100, LOTRBiomeFeatures.oakSwamp(), 1000, LOTRBiomeFeatures.oakShrub(), 2500};
            LOTRBiomeFeatures.addTreesBelowTreeline(this, 2, 0.5f, 63, weightedTrees);
            LOTRBiomeFeatures.addTreesAboveTreeline(this, 3, 0.5f, 64, weightedTrees);
            LOTRBiomeFeatures.addGrassWithFernsWithoutPrettyTypes(this, 8);
            LOTRBiomeFeatures.addDoubleGrassWithFernsWithoutPrettyTypes(this, 8);
            LOTRBiomeFeatures.addSwampFlowers(this, 4, new Object[0]);
            LOTRBiomeFeatures.addMoreMushroomsFreq(this, 3);
            LOTRBiomeFeatures.addWaterLiliesWithRareFlowers(this, 4);
            LOTRBiomeFeatures.addSwampSeagrass(this);
            LOTRBiomeFeatures.addFallenLogs(this, 2);
            LOTRBiomeFeatures.addWildPipeweedChance(this, 3);
        }

        @Override
        protected void addReeds() {
            super.addReeds();
            LOTRBiomeFeatures.addMoreSwampReeds(this);
            LOTRBiomeFeatures.addSwampRushes(this);
        }

        @Override
        protected void addAnimals() {
        }

        @Override
        protected void addStructures() {
        }

        @Override
        public LOTRBiomeBase getRiver() {
            return null;
        }
    }

    public static class WhiteDowns
    extends ShireBiome {
        public WhiteDowns(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.7f).func_205420_b(0.6f).func_205414_c(0.6f).func_205417_d(0.8f), major);
            this.biomeColors.resetGrass();
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setFillerDepth(0.0);
            config.addSubSoilLayer(((Block)LOTRBlocks.DIRTY_CHALK.get()).func_176223_P(), 1);
            config.addSubSoilLayer(((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 4);
        }

        @Override
        protected void addStoneVariants() {
            super.addStoneVariants();
            LOTRBiomeFeatures.addDiorite(this);
        }

        @Override
        protected void addBoulders() {
            super.addBoulders();
            LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 3, 80, 3);
            LOTRBiomeFeatures.addBoulders(this, ((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 1, 1, 16, 3);
            LOTRBiomeFeatures.addBoulders(this, ((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 2, 3, 32, 2);
        }

        @Override
        protected void addVegetation() {
            LOTRBiomeFeatures.addTrees(this, 0, 0.08f, this.shireTrees());
            LOTRBiomeFeatures.addShireMoorsGrass(this, 6);
            LOTRBiomeFeatures.addMoorsDoubleGrass(this, 1);
            LOTRBiomeFeatures.addPlainsFlowers(this, 2, LOTRBlocks.SHIRE_HEATHER.get(), 20);
            LOTRBiomeFeatures.addWildPipeweedChance(this, 12);
        }

        @Override
        protected void addAnimals() {
            super.addAnimals();
        }
    }

    public static class Moors
    extends ShireBiome {
        public Moors(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.6f).func_205420_b(0.6f).func_205414_c(0.6f).func_205417_d(1.0f), major);
            this.biomeColors.resetGrass();
        }

        @Override
        protected void addBoulders() {
            super.addBoulders();
            LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 2, 8, 4);
            LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 3, 5, 40, 3);
        }

        @Override
        protected void addVegetation() {
            LOTRBiomeFeatures.addTrees(this, 0, 0.1f, LOTRUtil.combineVarargs(this.shireTrees(), LOTRBiomeFeatures.oakFancy(), 80000, LOTRBiomeFeatures.oakFancyBees(), 800));
            LOTRBiomeFeatures.addShireMoorsGrass(this, 6);
            LOTRBiomeFeatures.addMoorsDoubleGrass(this, 1);
            LOTRBiomeFeatures.addPlainsFlowers(this, 10, LOTRBlocks.SHIRE_HEATHER.get(), 100);
            LOTRBiomeFeatures.addWildPipeweedChance(this, 12);
        }

        @Override
        protected void addAnimals() {
            super.addAnimals();
        }
    }
}

