/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class SouthronCoastsBiome
extends LOTRBiomeBase {
    public SouthronCoastsBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.2f).func_205420_b(0.1f).func_205414_c(1.2f).func_205417_d(0.7f), major);
        this.biomeColors.setGrass(11914805);
        this.biomeColors.setFog(16248281);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.25, 0.07, 0.002) > 0.13) {
                return top ? Blocks.field_196660_k.func_176223_P() : in;
            }
            if (config.getNoise2(x, z, 0.25, 0.07, 0.002) > 0.3) {
                return Blocks.field_150354_m.func_176223_P();
            }
            if (config.getNoise3(x, z, 0.25, 0.07, 0.002) > 0.53) {
                return Blocks.field_196611_F.func_176223_P();
            }
            return in;
        });
    }

    @Override
    protected void addOres() {
        super.addOres();
        LOTRBiomeFeatures.addLapisOre(this);
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.2f, TreeCluster.of(8, 24), LOTRBiomeFeatures.cedar(), 8000, LOTRBiomeFeatures.oakDesert(), 5000, LOTRBiomeFeatures.oakDesertBees(), 50, LOTRBiomeFeatures.cypress(), 4000);
        LOTRBiomeFeatures.addGrass(this, 10);
        LOTRBiomeFeatures.addDoubleGrass(this, 2);
        LOTRBiomeFeatures.addDeadBushes(this, 1);
        LOTRBiomeFeatures.addHaradFlowers(this, 3, new Object[0]);
        LOTRBiomeFeatures.addHaradDoubleFlowers(this, 1, new Object[0]);
        LOTRBiomeFeatures.addCactiFreq(this, 1);
    }

    @Override
    protected void addReeds() {
        LOTRBiomeFeatures.addLessCommonReeds(this);
        LOTRBiomeFeatures.addPapyrus(this);
        LOTRBiomeFeatures.addSugarCane(this);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
        this.addHorsesDonkeys(3);
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, ((Block)LOTRBlocks.HARAD_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.HARAD_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.CEDAR_FENCE.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.BRONZE_LANTERN.get()).func_176223_P(), 1));
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.SOUTHRON_COASTS;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.HARAD_PATH;
    }
}

