/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;

public class TolfalasBiome
extends LOTRBiomeBase {
    public TolfalasBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.OCEAN).func_205421_a(0.3f).func_205420_b(1.0f).func_205414_c(0.8f).func_205417_d(0.7f), major);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.4, 0.09) > 0.65) {
                return top ? Blocks.field_150351_n.func_176223_P() : in;
            }
            if (config.getNoise2(x, z, 0.4, 0.09) > 0.2) {
                return top ? Blocks.field_150348_b.func_176223_P() : in;
            }
            return in;
        });
        config.setMountainTerrain((x, z, y, in, stone, top, rockDepth) -> {
            int stoneLine = 90 - rockDepth;
            if (y >= stoneLine && in.func_177230_c() != stone.func_177230_c()) {
                return Blocks.field_150348_b.func_176223_P();
            }
            return in;
        });
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 1, 4, 10, 3);
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTrees(this, 1, 0.4f, LOTRBiomeFeatures.oak(), 100, LOTRBiomeFeatures.oakDesert(), 500, LOTRBiomeFeatures.oakDead(), 2000);
        LOTRBiomeFeatures.addGrass(this, 10);
        LOTRBiomeFeatures.addDoubleGrass(this, 6);
        LOTRBiomeFeatures.addDefaultFlowers(this, 1, new Object[0]);
        LOTRBiomeFeatures.addAthelasChance(this);
    }

    @Override
    protected void addReeds() {
        super.addReeds();
        LOTRBiomeFeatures.addSugarCane(this);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.TOLFALAS;
    }
}

