/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;

public class TrollshawsBiome
extends LOTRBiomeBase {
    public TrollshawsBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.15f).func_205420_b(0.9f).func_205414_c(0.6f).func_205417_d(0.8f), major);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.007) + config.getNoise1(x, z, 0.2, 0.06) > 0.9) {
                return Blocks.field_196650_c.func_176223_P();
            }
            if (config.getNoise2(x, z, 0.007) + config.getNoise2(x, z, 0.2, 0.06) > 0.65) {
                return Blocks.field_196654_e.func_176223_P();
            }
            return in;
        });
    }

    @Override
    protected void addStoneVariants() {
        LOTRBiomeFeatures.addCommonGranite(this);
        LOTRBiomeFeatures.addDiorite(this);
    }

    @Override
    protected void addBoulders() {
        LOTRBiomeFeatures.addBoulders(this, Blocks.field_150348_b.func_176223_P(), 2, 6, 8, 3);
    }

    @Override
    protected void addVegetation() {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oak(), 5000, LOTRBiomeFeatures.oakTall(), 5000, LOTRBiomeFeatures.oakFancy(), 2000, LOTRBiomeFeatures.oakBees(), 10, LOTRBiomeFeatures.oakTallBees(), 10, LOTRBiomeFeatures.oakFancyBees(), 2, LOTRBiomeFeatures.beech(), 5000, LOTRBiomeFeatures.beechFancy(), 2000, LOTRBiomeFeatures.beechBees(), 5, LOTRBiomeFeatures.beechFancyBees(), 2, LOTRBiomeFeatures.spruce(), 1000, LOTRBiomeFeatures.fir(), 1000, LOTRBiomeFeatures.pine(), 1000, LOTRBiomeFeatures.maple(), 500, LOTRBiomeFeatures.mapleFancy(), 200, LOTRBiomeFeatures.mapleBees(), 10, LOTRBiomeFeatures.mapleFancyBees(), 10, LOTRBiomeFeatures.aspen(), 1000, LOTRBiomeFeatures.aspenLarge(), 200};
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.4f, TreeCluster.of(6, 10), weightedTrees);
        LOTRBiomeFeatures.addTreesBelowTreeline(this, 10, 0.0f, 82, weightedTrees);
        LOTRBiomeFeatures.addGrassWithFerns(this, 6);
        LOTRBiomeFeatures.addDoubleGrassWithFerns(this, 2);
        LOTRBiomeFeatures.addForestFlowers(this, 3, new Object[0]);
        LOTRBiomeFeatures.addDefaultDoubleFlowers(this, 3, new Object[0]);
        LOTRBiomeFeatures.addAthelasChance(this);
        LOTRBiomeFeatures.addFoxBerryBushes(this);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
        this.addHorsesDonkeys();
        this.addWolves(2);
        this.addDeer(1);
        this.addBears(3);
        this.addElk(2);
        this.addFoxes(1);
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.TROLLSHAWS;
    }
}

