/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class UmbarBiome
extends LOTRBiomeBase {
    public UmbarBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.9f).func_205417_d(0.6f), major);
        this.biomeColors.setGrass(11914805);
        this.biomeColors.setFog(16248281);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setSurfaceNoiseMixer((x, z, in, top, rand) -> {
            if (config.getNoise1(x, z, 0.25, 0.07, 0.002) > 0.2) {
                return top ? Blocks.field_196660_k.func_176223_P() : in;
            }
            if (config.getNoise2(x, z, 0.25, 0.07, 0.002) > 0.3667) {
                return Blocks.field_150354_m.func_176223_P();
            }
            return in;
        });
    }

    @Override
    protected void addOres() {
        super.addOres();
        LOTRBiomeFeatures.addLapisOre(this);
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTreesWithClusters(this, 0, 0.15f, TreeCluster.of(10, 30), LOTRBiomeFeatures.oakDesert(), 10000, LOTRBiomeFeatures.oakDesertBees(), 10, LOTRBiomeFeatures.cedar(), 3000, LOTRBiomeFeatures.cypress(), 5000);
        LOTRBiomeFeatures.addGrass(this, 6);
        LOTRBiomeFeatures.addDoubleGrass(this, 1);
        LOTRBiomeFeatures.addHaradFlowers(this, 3, new Object[0]);
        LOTRBiomeFeatures.addHaradDoubleFlowers(this, 1, new Object[0]);
    }

    @Override
    protected void addReeds() {
        LOTRBiomeFeatures.addLessCommonReeds(this);
        LOTRBiomeFeatures.addPapyrus(this);
        LOTRBiomeFeatures.addSugarCane(this);
    }

    @Override
    protected void addAnimals() {
        super.addAnimals();
        this.addHorsesDonkeys(1);
    }

    @Override
    protected void addStructures() {
        LOTRBiomeFeatures.addCraftingMonument(this, ((Block)LOTRBlocks.UMBAR_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.UMBAR_BRICK.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.NUMENOREAN_BRICK_WALL.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_150478_aa.func_176223_P(), 1));
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.UMBAR;
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.UMBAR;
    }
}

