/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.MiddleEarthSurfaceConfig;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;

public class WhiteMountainsBiome
extends LOTRBiomeBase {
    public WhiteMountainsBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(1.5f).func_205420_b(2.0f).func_205414_c(0.6f).func_205417_d(0.8f), major);
    }

    protected WhiteMountainsBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
    }

    protected boolean isFoothills() {
        return false;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        if (!this.isFoothills()) {
            config.setMountainTerrain((x, z, y, in, stone, top, rockDepth) -> {
                int stoneLine = 100 - rockDepth;
                if (y >= stoneLine && in.func_177230_c() != stone.func_177230_c()) {
                    return ((Block)LOTRBlocks.GONDOR_ROCK.get()).func_176223_P();
                }
                return in;
            });
        }
    }

    @Override
    protected void addOres() {
        super.addOres();
    }

    @Override
    protected void addVegetation() {
        LOTRBiomeFeatures.addTrees(this, 1, 0.1f, LOTRBiomeFeatures.oak(), 1000, LOTRBiomeFeatures.oakFancy(), 500, LOTRBiomeFeatures.birch(), 200, LOTRBiomeFeatures.birchFancy(), 50, LOTRBiomeFeatures.beech(), 200, LOTRBiomeFeatures.beechFancy(), 50, LOTRBiomeFeatures.spruce(), 3000, LOTRBiomeFeatures.larch(), 3000, LOTRBiomeFeatures.fir(), 5000, LOTRBiomeFeatures.pine(), 5000, LOTRBiomeFeatures.apple(), 50, LOTRBiomeFeatures.pear(), 50);
        LOTRBiomeFeatures.addGrassWithoutPrettyTypes(this, 6);
        LOTRBiomeFeatures.addDoubleGrassWithoutPrettyTypes(this, 2);
        LOTRBiomeFeatures.addMountainsFlowers(this, 2, new Object[0]);
    }

    @Override
    protected void addLiquidSprings() {
        if (!this.isFoothills()) {
            LOTRBiomeFeatures.addWaterLavaSpringsReducedAboveground(this, 80, 0.15f);
        } else {
            super.addLiquidSprings();
        }
    }

    @Override
    protected void addAnimals() {
    }

    @Override
    public WaypointRegion getWaypointRegion() {
        return WaypointRegion.WHITE_MOUNTAINS;
    }

    public static class Foothills
    extends WhiteMountainsBiome {
        public Foothills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(0.5f).func_205420_b(0.9f).func_205414_c(0.6f).func_205417_d(0.7f), major);
        }

        @Override
        protected boolean isFoothills() {
            return true;
        }
    }
}

