/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.fac;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import lotr.common.LOTRLog;
import lotr.common.data.InstancedJsonReloadListener;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionRegion;
import lotr.common.fac.FactionRelationsTable;
import lotr.common.fac.FactionSettings;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.SPacketFactionSettings;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapSettingsManager;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.fml.LogicalSide;

public class FactionSettingsManager
extends InstancedJsonReloadListener {
    private static final String FACTION_FOLDER = "factions";
    private static final String REGION_SUBFOLDER = "regions/";
    private static final String RELATIONS_SUBFOLDER = "relations/";
    private static final FactionSettingsManager CLIENT_INSTANCE = new FactionSettingsManager(LogicalSide.CLIENT);
    private static final FactionSettingsManager SERVER_INSTANCE = new FactionSettingsManager(LogicalSide.SERVER);
    private FactionSettings currentLoadedFactions;

    private FactionSettingsManager(LogicalSide side) {
        super(FACTION_FOLDER, "FactionSettings", side);
    }

    public static FactionSettingsManager clientInstance() {
        return CLIENT_INSTANCE;
    }

    public static FactionSettingsManager serverInstance() {
        return SERVER_INSTANCE;
    }

    public static FactionSettingsManager sidedInstance(IWorldReader world) {
        return !world.func_201670_d() ? SERVER_INSTANCE : CLIENT_INSTANCE;
    }

    public static FactionSettingsManager sidedInstance(LogicalSide side) {
        return side == LogicalSide.SERVER ? SERVER_INSTANCE : CLIENT_INSTANCE;
    }

    public void loadClientFactionsFromServer(IResourceManager resMgr, FactionSettings facSettings) {
        this.currentLoadedFactions = facSettings;
        this.logFactionsLoad("Loaded clientside faction settings from server", this.currentLoadedFactions);
    }

    private FactionSettings loadFactionsFromJsons(IResourceManager resMgr, Map<ResourceLocation, JsonObject> regionJsons, Map<ResourceLocation, JsonObject> factionJsons, Map<ResourceLocation, JsonObject> relationsJsons, MapSettings mapSettings) {
        ArrayList<FactionRegion> regions = new ArrayList<FactionRegion>();
        int nextRegionId = 0;
        for (Map.Entry<ResourceLocation, JsonObject> entry : regionJsons.entrySet()) {
            ResourceLocation res = entry.getKey();
            ResourceLocation regionName = new ResourceLocation(res.func_110624_b(), res.func_110623_a().substring(REGION_SUBFOLDER.length()));
            JsonObject jsonObject = entry.getValue();
            try {
                FactionRegion factionRegion = FactionRegion.read(regionName, jsonObject, nextRegionId);
                if (factionRegion != null) {
                    regions.add(factionRegion);
                }
                ++nextRegionId;
            }
            catch (Exception exception) {
                LOTRLog.warn("Failed to load faction region %s from file", regionName);
                exception.printStackTrace();
            }
        }
        FactionSettings facSettings = new FactionSettings(regions);
        ArrayList<Faction> factions = new ArrayList<Faction>();
        int nextFactionId = 0;
        for (Map.Entry entry : factionJsons.entrySet()) {
            ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
            ResourceLocation factionName = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a());
            JsonObject factionJson = (JsonObject)entry.getValue();
            try {
                Faction faction = Faction.read(facSettings, factionName, factionJson, nextFactionId, mapSettings);
                if (faction != null) {
                    factions.add(faction);
                }
                ++nextFactionId;
            }
            catch (Exception e) {
                LOTRLog.warn("Failed to load faction %s from file", factionName);
                e.printStackTrace();
            }
        }
        facSettings.setFactions(factions);
        ArrayList<FactionRelationsTable> relationsTables = new ArrayList<FactionRelationsTable>();
        for (Map.Entry<ResourceLocation, JsonObject> entry : relationsJsons.entrySet()) {
            ResourceLocation res = entry.getKey();
            ResourceLocation relationsName = new ResourceLocation(res.func_110624_b(), res.func_110623_a().substring(RELATIONS_SUBFOLDER.length()));
            JsonObject relationsJson = entry.getValue();
            try {
                FactionRelationsTable relations = FactionRelationsTable.read(facSettings, relationsName, relationsJson);
                if (relations == null) continue;
                relationsTables.add(relations);
            }
            catch (Exception e) {
                LOTRLog.warn("Failed to load faction relations table %s from file", relationsName);
                e.printStackTrace();
            }
        }
        FactionRelationsTable factionRelationsTable = FactionRelationsTable.combine(relationsTables);
        facSettings.setRelations(factionRelationsTable);
        return facSettings;
    }

    public FactionSettings getCurrentLoadedFactions() {
        return this.currentLoadedFactions;
    }

    protected void apply(Map<ResourceLocation, JsonObject> jsons, IResourceManager serverResMgr, IProfiler profiler) {
        Map<ResourceLocation, JsonObject> regionJsons = this.filterDataJsonsBySubFolder(jsons, REGION_SUBFOLDER);
        Map<ResourceLocation, JsonObject> factionJsons = this.filterDataJsonsByRootFolderOnly(jsons);
        Map<ResourceLocation, JsonObject> relationsJsons = this.filterDataJsonsBySubFolder(jsons, RELATIONS_SUBFOLDER);
        MapSettings mapSettings = MapSettingsManager.serverInstance().getCurrentLoadedMap();
        this.currentLoadedFactions = this.loadFactionsFromJsons(serverResMgr, regionJsons, factionJsons, relationsJsons, mapSettings);
        this.logFactionsLoad("Loaded serverside faction settings", this.currentLoadedFactions);
    }

    private void logFactionsLoad(String prefix, FactionSettings facSettings) {
        LOTRLog.info("%s - %d factions in %d regions, with %d relations (combined from %d relations lists)", prefix, facSettings.getFactions().size(), facSettings.getRegions().size(), facSettings.getRelations().size(), facSettings.getRelations().getNumCombinedFrom());
    }

    public void sendFactionsToPlayer(ServerPlayerEntity player) {
        SPacketFactionSettings packet = new SPacketFactionSettings(this.currentLoadedFactions);
        LOTRPacketHandler.sendTo(packet, player);
    }
}

