/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen;

import java.util.List;
import java.util.Random;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRWorldTypes;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.gen.MiddleEarthGenSettings;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.RoadGenerator;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class MiddleEarthChunkGenerator
extends NoiseChunkGenerator<MiddleEarthGenSettings> {
    private final OctavesNoiseGenerator depthNoise;
    private final boolean isAmplified;
    private final int noiseSizeX;
    private final int noiseSizeY;
    private final int noiseSizeZ;
    private final int biomeSampleRadius;
    private final int biomeSampleWidth;
    private final float[] biomeSaplingSignificance;
    private final int riverSampleRadius;
    private final float[] riverSampleIndicator;
    private final RoadGenerator roadGenerator = new RoadGenerator();
    private static final int ROAD_TERRAIN_FLATTEN_RANGE = 64;
    private static final float ROAD_TERRAIN_FLATTEN_FACTOR = 0.85f;

    public MiddleEarthChunkGenerator(IWorld worldIn, BiomeProvider provider, MiddleEarthGenSettings settings) {
        this(worldIn, provider, 4, 8, 256, settings);
    }

    private MiddleEarthChunkGenerator(IWorld worldIn, BiomeProvider provider, int hNoiseGran, int vNoiseGran, int height, MiddleEarthGenSettings settings) {
        super(worldIn, provider, hNoiseGran, vNoiseGran, height, (GenerationSettings)settings, true);
        this.field_222558_e.func_202423_a(2620);
        this.depthNoise = new OctavesNoiseGenerator(this.field_222558_e, 15, 0);
        this.isAmplified = false;
        this.noiseSizeX = 16 / hNoiseGran;
        this.noiseSizeY = height / vNoiseGran;
        this.noiseSizeZ = 16 / hNoiseGran;
        this.biomeSampleRadius = 6;
        this.biomeSampleWidth = this.biomeSampleRadius * 2 + 1;
        this.biomeSaplingSignificance = (float[])Util.func_200696_a((Object)new float[this.biomeSampleWidth * this.biomeSampleWidth], array -> {
            for (int z = -this.biomeSampleRadius; z <= this.biomeSampleRadius; ++z) {
                for (int x = -this.biomeSampleRadius; x <= this.biomeSampleRadius; ++x) {
                    float f;
                    array[z + this.biomeSampleRadius + (x + this.biomeSampleRadius) * this.biomeSampleWidth] = f = 10.0f / MathHelper.func_76129_c((float)((float)(z * z + x * x) + 0.2f));
                }
            }
        });
        this.riverSampleRadius = 3;
        this.riverSampleIndicator = (float[])Util.func_200696_a((Object)new float[this.biomeSampleWidth * this.biomeSampleWidth], array -> {
            for (int z = -this.biomeSampleRadius; z <= this.biomeSampleRadius; ++z) {
                for (int x = -this.biomeSampleRadius; x <= this.biomeSampleRadius; ++x) {
                    float f;
                    float d = MathHelper.func_76129_c((float)(x * x + z * z));
                    float f2 = f = d <= (float)this.riverSampleRadius ? 1.0f : MathHelper.func_219799_g((float)((d - (float)this.riverSampleRadius) / (float)(this.biomeSampleRadius - this.riverSampleRadius)), (float)1.0f, (float)0.0f);
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    array[z + this.biomeSampleRadius + (x + this.biomeSampleRadius) * this.biomeSampleWidth] = f;
                }
            }
        });
    }

    public void func_225551_a_(WorldGenRegion region, IChunk chunk) {
        super.func_225551_a_(region, chunk);
        if (LOTRWorldTypes.hasMapFeatures((IWorld)region)) {
            ChunkPos chunkPos = chunk.func_76632_l();
            int chunkX = chunkPos.field_77276_a;
            int chunkZ = chunkPos.field_77275_b;
            SharedSeedRandom rand = new SharedSeedRandom();
            rand.func_202422_a(chunkX, chunkZ);
            int xStart = chunkPos.func_180334_c();
            int zStart = chunkPos.func_180333_d();
            BlockPos.Mutable movingPos = new BlockPos.Mutable();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int posX = xStart + x;
                    int posZ = zStart + z;
                    int topY = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, x, z);
                    movingPos.func_181079_c(posX, topY, posZ);
                    Biome biome = region.func_226691_t_((BlockPos)movingPos);
                    if (!(biome instanceof LOTRBiomeBase)) continue;
                    this.roadGenerator.generateRoad((IWorld)region, chunk, (Random)rand, (LOTRBiomeBase)biome, (BlockPos)movingPos, this.func_222530_f());
                }
            }
        }
    }

    protected void func_222548_a(double[] noiseColumn, int noiseX, int noiseZ) {
        double coordScaleXZ = 484.412;
        double coordScaleY = 1.0;
        Biome biome = this.field_222542_c.func_225526_b_(noiseX, this.func_222530_f(), noiseZ);
        double xzNoiseScale = biome instanceof LOTRBiomeBase ? ((LOTRBiomeBase)biome).getHorizontalNoiseScale() : ((LOTRBiomeBase)LOTRBiomes.SHIRE.get()).getHorizontalNoiseScale();
        double yNoiseScale = 5000.0;
        double scaledNoiseXZ = coordScaleXZ / xzNoiseScale;
        double scaledNoiseY = coordScaleY / yNoiseScale;
        int i = -10;
        int j = 3;
        this.func_222546_a(noiseColumn, noiseX, noiseZ, coordScaleXZ, coordScaleY, scaledNoiseXZ, scaledNoiseY, 3, -10);
    }

    protected double func_222545_a(double baseHeight, double heightVariation, int yIndex) {
        double heightStretch = 12.0;
        double d0 = 8.5;
        double d1 = ((double)yIndex - (8.5 + baseHeight * 8.5 / 8.0 * 4.0)) * heightStretch * 128.0 / 256.0 / heightVariation;
        if (d1 < 0.0) {
            d1 *= 4.0;
        }
        return d1;
    }

    protected double[] func_222549_a(int noiseX, int noiseZ) {
        float roadNear;
        int blockX = noiseX * this.noiseSizeX + this.noiseSizeX / 2;
        int blockZ = noiseZ * this.noiseSizeZ + this.noiseSizeZ / 2;
        int seaLevel = this.func_222530_f();
        double[] depthAndScale = new double[2];
        float totalScale = 0.0f;
        float totalDepth = 0.0f;
        float totalDepthWithoutVariants = 0.0f;
        float totalAddedDepthNoiseStrength = 0.0f;
        float totalModifiedSignificance = 0.0f;
        float totalSignificance = 0.0f;
        float centralDepth = this.field_222542_c.func_225526_b_(noiseX, seaLevel, noiseZ).func_185355_j();
        for (int k = -this.biomeSampleRadius; k <= this.biomeSampleRadius; ++k) {
            for (int l = -this.biomeSampleRadius; l <= this.biomeSampleRadius; ++l) {
                float scaleSignificance;
                float addedDepthNoiseStrength;
                Biome biome = this.field_222542_c.func_225526_b_(noiseX + k, seaLevel, noiseZ + l);
                float depth = biome.func_185355_j();
                if (biome instanceof LOTRBiomeBase) {
                    LOTRBiomeBase modBiome = (LOTRBiomeBase)biome;
                    addedDepthNoiseStrength = modBiome.getStrengthOfAddedDepthNoise();
                    scaleSignificance = modBiome.getBiomeScaleSignificanceForChunkGen();
                } else {
                    addedDepthNoiseStrength = 1.0f;
                    scaleSignificance = 0.9f;
                }
                float scale = biome.func_185360_m() * scaleSignificance + (1.0f - scaleSignificance);
                if (scale == 0.0f) {
                    scale = 1.0E-7f;
                }
                if (this.isAmplified && depth > 0.0f) {
                    depth = 1.0f + depth * 2.0f;
                    scale = 1.0f + scale * 4.0f;
                }
                float depthWithoutVariants = depth;
                int arrayIndex = k + this.biomeSampleRadius + (l + this.biomeSampleRadius) * this.biomeSampleWidth;
                float significance = this.biomeSaplingSignificance[arrayIndex];
                float modifiedSignificance = significance / (depth + 2.0f);
                if (biome.func_185355_j() > centralDepth) {
                    modifiedSignificance /= 2.0f;
                }
                if (biome instanceof LOTRBiomeBase && ((LOTRBiomeBase)biome).isRiver()) {
                    float affectingFactor = 5.0f;
                    if (centralDepth < 0.0f) {
                        affectingFactor *= 2.0f;
                    }
                    modifiedSignificance *= affectingFactor;
                }
                totalScale += scale * modifiedSignificance;
                totalDepth += depth * modifiedSignificance;
                totalDepthWithoutVariants += depthWithoutVariants * modifiedSignificance;
                totalModifiedSignificance += modifiedSignificance;
                totalAddedDepthNoiseStrength += addedDepthNoiseStrength * significance;
                totalSignificance += significance;
            }
        }
        float avgScale = totalScale / totalModifiedSignificance;
        float avgDepth = totalDepth / totalModifiedSignificance;
        float avgDepthWithoutVariants = totalDepthWithoutVariants / totalModifiedSignificance;
        float avgAddedDepthNoiseStrength = totalAddedDepthNoiseStrength / totalSignificance;
        if (LOTRWorldTypes.hasMapFeatures(this.field_222540_a) && (roadNear = MapSettingsManager.serverInstance().getCurrentLoadedMap().getRoadPointCache().getRoadCentreCloseness(blockX, blockZ, 64)) >= 0.0f) {
            float flattenFactor = Math.min(roadNear + 0.15f, 1.0f) * 0.85f;
            avgDepth += (avgDepthWithoutVariants - avgDepth) * flattenFactor;
            avgScale *= 1.0f - flattenFactor;
        }
        if (centralDepth < 0.0f && avgDepth >= 0.0f) {
            float lerpFactor = 0.5f;
            avgDepth = MathHelper.func_219799_g((float)lerpFactor, (float)avgDepth, (float)(centralDepth / 2.0f));
        }
        float avgDepthBeforeAddNoise = avgDepth;
        double depthNoiseAdd = this.getNoiseDepthAt(noiseX, noiseZ);
        depthNoiseAdd = (depthNoiseAdd * 8.0 + 1.0) / 4.0;
        avgDepth = (float)((double)avgDepth + depthNoiseAdd * (double)avgAddedDepthNoiseStrength);
        avgDepth = (avgDepth * 4.0f - 1.0f) / 8.0f;
        depthAndScale[0] = avgDepth;
        depthAndScale[1] = avgScale;
        return depthAndScale;
    }

    private double getNoiseDepthAt(int noiseX, int noiseZ) {
        double d0 = this.depthNoise.func_215462_a((double)(noiseX * 200), 10.0, (double)(noiseZ * 200), 1.0, 0.0, true) * 65535.0 / 8000.0;
        if (d0 < 0.0) {
            d0 = -d0 * 0.3;
        }
        if ((d0 = d0 * 3.0 - 2.0) < 0.0) {
            d0 /= 28.0;
        } else {
            if (d0 > 1.0) {
                d0 = 1.0;
            }
            d0 /= 40.0;
        }
        return d0;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification creatureType, BlockPos pos) {
        Biome biome = this.field_222540_a.func_226691_t_(pos);
        if (biome instanceof LOTRBiomeBase) {
            return ((LOTRBiomeBase)biome).getSpawnsAtLocation(creatureType, this.field_222540_a, pos);
        }
        return super.func_177458_a(creatureType, pos);
    }

    public void func_203222_a(ServerWorld world, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
    }

    public void func_202093_c(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        Biome biome = region.func_226691_t_(new ChunkPos(i, j).func_206849_h());
        SharedSeedRandom rand = new SharedSeedRandom();
        rand.func_202424_a(region.func_72905_C(), i << 4, j << 4);
        WorldEntitySpawner.func_77191_a((IWorld)region, (Biome)biome, (int)i, (int)j, (Random)rand);
    }

    public int func_205470_d() {
        return this.field_222540_a.func_181545_F() + 1;
    }

    public int func_222530_f() {
        return 63;
    }
}

