/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import lotr.common.world.gen.feature.ExtendedTreeConfig;
import lotr.common.world.gen.feature.ExtendedTreeFeature;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;

public class BoughsTreeFeature
extends ExtendedTreeFeature<ExtendedTreeConfig> {
    public BoughsTreeFeature(Function<Dynamic<?>, ? extends ExtendedTreeConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> trunk, Set<BlockPos> leaves, MutableBoundingBox bb, ExtendedTreeConfig config) {
        int y;
        int maxCheckWidth;
        int leafHeight;
        int trunkHeight = config.field_227371_p_ + rand.nextInt(config.field_227328_b_ + 1) + rand.nextInt(config.field_227329_c_ + 1);
        Optional canGrow = this.func_227212_a_(world, trunkHeight, leafHeight = config.field_227330_d_ >= 0 ? config.field_227330_d_ + rand.nextInt(config.field_227331_f_ + 1) : trunkHeight - (config.field_227334_i_ + rand.nextInt(config.field_227335_j_ + 1)), maxCheckWidth = config.field_227327_a_.func_225573_a_(rand, leafHeight, trunkHeight, (TreeFeatureConfig)config), pos, config);
        if (!canGrow.isPresent()) {
            return false;
        }
        BlockPos growPos = (BlockPos)canGrow.get();
        this.setDirtAt(world, growPos.func_177977_b(), growPos);
        int branchMinHeight = (int)((float)trunkHeight * 0.6f);
        int branchMaxHeight = trunkHeight - 1;
        this.placeWood(world, rand, growPos.func_177982_a(0, branchMaxHeight, 0), trunk, bb, config, Direction.Axis.Y);
        int deg = 0;
        for (y = branchMaxHeight; y >= branchMinHeight; --y) {
            int branches = 1 + rand.nextInt(2);
            for (int b = 0; b < branches; ++b) {
                float angle = (float)Math.toRadians(deg += 50 + rand.nextInt(70));
                float cos = MathHelper.func_76134_b((float)angle);
                float sin = MathHelper.func_76126_a((float)angle);
                float angleY = rand.nextFloat() * (float)Math.toRadians(50.0);
                float cosY = MathHelper.func_76134_b((float)angleY);
                float sinY = MathHelper.func_76126_a((float)angleY);
                int length = 4 + rand.nextInt(6);
                BlockPos.Mutable branchPos = new BlockPos.Mutable(growPos).func_196234_d(0, y, 0);
                Direction.Axis branchAxis = Direction.func_176733_a((double)(deg + 90)).func_176740_k();
                for (int l = 0; l < length; ++l) {
                    if (Math.floor(cos * (float)l) != Math.floor(cos * (float)(l - 1))) {
                        branchPos.func_196234_d((int)Math.signum(cos), 0, 0);
                    }
                    if (Math.floor(sin * (float)l) != Math.floor(sin * (float)(l - 1))) {
                        branchPos.func_196234_d(0, 0, (int)Math.signum(sin));
                    }
                    if (Math.floor(sinY * (float)l) != Math.floor(sinY * (float)(l - 1))) {
                        branchPos.func_196234_d(0, (int)Math.signum(sinY), 0);
                    }
                    if (branchPos.func_177958_n() == growPos.func_177958_n() && branchPos.func_177952_p() == growPos.func_177952_p() && branchPos.func_177956_o() <= growPos.func_177956_o() + branchMaxHeight) continue;
                    if (!this.canLeavesReplace(world, (BlockPos)branchPos, config)) break;
                    this.placeWood(world, rand, (BlockPos)branchPos, trunk, bb, config, branchAxis);
                }
                this.growLeafCanopy(world, rand, (BlockPos)branchPos, leaves, bb, config);
            }
        }
        for (y = 0; y < trunkHeight; ++y) {
            this.func_227216_a_(world, rand, growPos.func_177981_b(y), trunk, bb, (BaseTreeFeatureConfig)config);
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int rootUp = rand.nextInt(3);
            int rootLength = 3 + rootUp + rand.nextInt(3);
            int maxOut = 1;
            if (rootUp >= 2 && rand.nextBoolean()) {
                ++maxOut;
            }
            BlockPos.Mutable rootPos = new BlockPos.Mutable(growPos).func_196234_d(dir.func_82601_c(), rootUp, dir.func_82599_e());
            this.growRootsDownAndThenOut(world, rand, rootPos, rootLength, dir, maxOut, trunk, bb, config);
        }
        return true;
    }

    private void growLeafCanopy(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> leaves, MutableBoundingBox bb, ExtendedTreeConfig config) {
        int leafStart = -1;
        int leafTop = 2;
        int maxRange = 4 + rand.nextInt(2);
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        for (int y = leafStart; y <= leafTop; ++y) {
            int leafRangeAdd = -2;
            if (y >= 0) {
                leafRangeAdd = 0 - y;
            }
            int leafRange = maxRange + leafRangeAdd;
            int leafRangeSq = leafRange * leafRange;
            for (int x = -leafRange; x <= leafRange; ++x) {
                for (int z = -leafRange; z <= leafRange; ++z) {
                    boolean grow;
                    int dSq = x * x + z * z;
                    int dCh = Math.abs(x) + Math.abs(y) + Math.abs(z);
                    boolean bl = grow = dSq < leafRangeSq && dCh <= 7;
                    if (Math.abs(x) == leafRange - 1 || Math.abs(z) == leafRange - 1) {
                        grow &= rand.nextInt(4) != 0;
                    }
                    if (!grow) continue;
                    movingPos.func_189533_g((Vec3i)pos).func_196234_d(x, y, z);
                    if (!this.canLeavesReplace(world, (BlockPos)movingPos, config)) continue;
                    this.func_227219_b_(world, rand, (BlockPos)movingPos, leaves, bb, (BaseTreeFeatureConfig)config);
                }
            }
        }
    }
}

