/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import lotr.common.world.gen.feature.BoulderFeatureConfig;
import lotr.common.world.gen.feature.LOTRFeatures;
import lotr.common.world.map.RoadPointCache;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class BoulderFeature
extends Feature<BoulderFeatureConfig> {
    public BoulderFeature(Function<Dynamic<?>, ? extends BoulderFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, BoulderFeatureConfig config) {
        int highestHeight;
        Biome biome = world.func_226691_t_(pos);
        int boulderWidth = MathHelper.func_76136_a((Random)rand, (int)config.minWidth, (int)config.maxWidth);
        if (!RoadPointCache.checkNotGeneratingWithinRangeOfRoad(world, pos, boulderWidth)) {
            return false;
        }
        int lowestHeight = highestHeight = pos.func_177956_o();
        for (int i = -boulderWidth; i <= boulderWidth; ++i) {
            for (int k = -boulderWidth; k <= boulderWidth; ++k) {
                BlockPos heightPos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177982_a(i, 0, k));
                if (!this.isSurfaceBlock(world, heightPos.func_177977_b())) {
                    return false;
                }
                int heightValue = heightPos.func_177956_o();
                if (heightValue > highestHeight) {
                    highestHeight = heightValue;
                }
                if (heightValue >= lowestHeight) continue;
                lowestHeight = heightValue;
            }
        }
        if (highestHeight - lowestHeight > config.heightCheck) {
            return false;
        }
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        int spheres = MathHelper.func_76136_a((Random)rand, (int)1, (int)Math.max(1, boulderWidth));
        for (int l = 0; l < spheres; ++l) {
            int xOffset = MathHelper.func_76136_a((Random)rand, (int)(-boulderWidth), (int)boulderWidth);
            int zOffset = MathHelper.func_76136_a((Random)rand, (int)(-boulderWidth), (int)boulderWidth);
            BlockPos boulderPos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177982_a(xOffset, 0, zOffset));
            int sphereWidth = MathHelper.func_76136_a((Random)rand, (int)config.minWidth, (int)config.maxWidth);
            for (int i = -sphereWidth; i <= sphereWidth; ++i) {
                for (int j = -sphereWidth; j <= sphereWidth; ++j) {
                    for (int k = -sphereWidth; k <= sphereWidth; ++k) {
                        int dist = i * i + j * j + k * k;
                        if (dist >= sphereWidth * sphereWidth && (dist >= (sphereWidth + 1) * (sphereWidth + 1) || rand.nextInt(3) != 0)) continue;
                        movingPos.func_189533_g((Vec3i)boulderPos.func_177982_a(i, j, k));
                        BlockPos below = movingPos.func_177977_b();
                        while (movingPos.func_177956_o() >= 0 && !world.func_180495_p(below).func_200015_d((IBlockReader)world, below)) {
                            movingPos.func_189533_g((Vec3i)below);
                            below = below.func_177977_b();
                        }
                        world.func_180501_a((BlockPos)movingPos, config.stateProvider.func_225574_a_(rand, (BlockPos)movingPos), 3);
                        LOTRFeatures.setGrassToDirtBelow(world, (BlockPos)movingPos);
                    }
                }
            }
        }
        return true;
    }

    private boolean isSurfaceBlock(IWorld world, BlockPos pos) {
        return LOTRFeatures.isSurfaceBlock(world, pos);
    }
}

