/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import lotr.common.world.gen.feature.LOTRFeatures;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class BoulderFeatureConfig
implements IFeatureConfig {
    public final BlockStateProvider stateProvider;
    public final int minWidth;
    public final int maxWidth;
    public final int heightCheck;

    public BoulderFeatureConfig(BlockStateProvider blockProv, int min, int max) {
        this(blockProv, min, max, 3);
    }

    public BoulderFeatureConfig(BlockStateProvider blockProv, int min, int max, int hCheck) {
        this.stateProvider = blockProv;
        this.minWidth = min;
        this.maxWidth = max;
        this.heightCheck = hCheck;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("block_provider"), (Object)this.stateProvider.func_218175_a(ops), (Object)ops.createString("min_width"), (Object)ops.createInt(this.minWidth), (Object)ops.createString("max_width"), (Object)ops.createInt(this.maxWidth), (Object)ops.createString("height_check"), (Object)ops.createInt(this.heightCheck))));
    }

    public static <T> BoulderFeatureConfig deserialize(Dynamic<T> dyn) {
        BlockStateProvider blockProv = LOTRFeatures.deserializeBlockProvider(dyn, "block_provider");
        int min = dyn.get("min_width").asInt(0);
        int max = dyn.get("max_width").asInt(0);
        int hCheck = dyn.get("height_check").asInt(3);
        return new BoulderFeatureConfig(blockProv, min, max, hCheck);
    }
}

