/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import lotr.common.world.gen.feature.ExtendedTreeConfig;
import lotr.common.world.gen.feature.ExtendedTreeFeature;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;

public class CedarTreeFeature
extends ExtendedTreeFeature<ExtendedTreeConfig> {
    public CedarTreeFeature(Function<Dynamic<?>, ? extends ExtendedTreeConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> trunk, Set<BlockPos> leaves, MutableBoundingBox bb, ExtendedTreeConfig config) {
        int canopyMin;
        int y;
        int maxCheckWidth;
        int leafHeight;
        int trunkHeight = config.field_227371_p_ + rand.nextInt(config.field_227328_b_ + 1) + rand.nextInt(config.field_227329_c_ + 1);
        Optional canGrow = this.func_227212_a_(world, trunkHeight, leafHeight = config.field_227330_d_ >= 0 ? config.field_227330_d_ + rand.nextInt(config.field_227331_f_ + 1) : trunkHeight - (config.field_227334_i_ + rand.nextInt(config.field_227335_j_ + 1)), maxCheckWidth = config.field_227327_a_.func_225573_a_(rand, leafHeight, trunkHeight, (TreeFeatureConfig)config), pos, config);
        if (!canGrow.isPresent()) {
            return false;
        }
        BlockPos growPos = (BlockPos)canGrow.get();
        this.setDirtAt(world, growPos.func_177977_b(), growPos);
        BlockPos.Mutable canopyPos = new BlockPos.Mutable();
        for (y = canopyMin = trunkHeight - 2; y <= trunkHeight; ++y) {
            int leafRange = 2 - (y - trunkHeight);
            canopyPos.func_189533_g((Vec3i)growPos).func_196234_d(0, y, 0);
            this.growLeafLayer(world, rand, (BlockPos)canopyPos, leaves, bb, config, leafRange);
            if (y != canopyMin) continue;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x != 0 && z != 0) continue;
                    canopyPos.func_189533_g((Vec3i)growPos).func_196234_d(x, y, z);
                    this.func_227219_b_(world, rand, (BlockPos)canopyPos, trunk, bb, (BaseTreeFeatureConfig)config);
                }
            }
        }
        for (y = trunkHeight - 1; y > trunkHeight / 2; y -= 1 + rand.nextInt(3)) {
            int branches = 1 + rand.nextInt(3);
            block4: for (int b = 0; b < branches; ++b) {
                float angle = rand.nextFloat() * (float)Math.PI * 2.0f;
                int length = MathHelper.func_76136_a((Random)rand, (int)4, (int)7);
                int leafLayers = 2 + rand.nextInt(2);
                BlockPos.Mutable branchPos = new BlockPos.Mutable();
                for (int l = 0; l < length; ++l) {
                    int branchX = (int)(0.5f + MathHelper.func_76134_b((float)angle) * (float)(l + 1));
                    int branchZ = (int)(0.5f + MathHelper.func_76126_a((float)angle) * (float)(l + 1));
                    int branchY = y - 3 + l / 2;
                    branchPos.func_189533_g((Vec3i)growPos).func_196234_d(branchX, branchY, branchZ);
                    if (!this.func_227216_a_(world, rand, (BlockPos)branchPos, trunk, bb, (BaseTreeFeatureConfig)config)) continue block4;
                    if (l != length - 1 || leafLayers < 3) continue;
                    BlockPos.Mutable woodPos = new BlockPos.Mutable();
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            if (x != 0 && z != 0) continue;
                            woodPos.func_189533_g((Vec3i)branchPos).func_196234_d(x, -1, z);
                            this.func_227216_a_(world, rand, (BlockPos)woodPos, trunk, bb, (BaseTreeFeatureConfig)config);
                        }
                    }
                }
                for (int y1 = 0; y1 < leafLayers; ++y1) {
                    int leafRange = 1 + y1;
                    this.growLeafLayer(world, rand, branchPos.func_177979_c(y1), leaves, bb, config, leafRange);
                }
            }
        }
        for (y = 0; y < trunkHeight; ++y) {
            this.func_227216_a_(world, rand, growPos.func_177981_b(y), trunk, bb, (BaseTreeFeatureConfig)config);
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (Math.abs(x) == Math.abs(z)) continue;
                BlockPos.Mutable rootPos = new BlockPos.Mutable(growPos).func_196234_d(x, rand.nextInt(2), z);
                int rootLength = 4 + rand.nextInt(3);
                this.growRootsDown(world, rand, rootPos, rootLength, trunk, bb, config);
            }
        }
        return true;
    }

    private void growLeafLayer(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> leaves, MutableBoundingBox bb, ExtendedTreeConfig config, int leafRange) {
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        int leafRangeSq = leafRange * leafRange;
        for (int x = -leafRange; x <= leafRange; ++x) {
            for (int z = -leafRange; z <= leafRange; ++z) {
                boolean grow;
                int dSq = x * x + z * z;
                boolean bl = grow = dSq <= leafRangeSq;
                if (!grow) continue;
                movingPos.func_189533_g((Vec3i)pos).func_196234_d(x, 0, z);
                if (!this.canLeavesReplace(world, (BlockPos)movingPos, config)) continue;
                this.func_227219_b_(world, rand, (BlockPos)movingPos, leaves, bb, (BaseTreeFeatureConfig)config);
            }
        }
    }
}

