/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import lotr.common.world.gen.feature.LOTRFeatures;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class CraftingMonumentFeatureConfig
implements IFeatureConfig {
    public final BlockState craftingTable;
    public final BlockStateProvider baseBlockProvider;
    public final BlockStateProvider postProvider;
    public final BlockStateProvider torchProvider;

    public CraftingMonumentFeatureConfig(BlockState table, BlockStateProvider base, BlockStateProvider post, BlockStateProvider torch) {
        this.craftingTable = table;
        this.baseBlockProvider = base;
        this.postProvider = post;
        this.torchProvider = torch;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("table_state"), (Object)BlockState.func_215689_a(ops, (BlockState)this.craftingTable).getValue(), (Object)ops.createString("base_provider"), (Object)this.baseBlockProvider.func_218175_a(ops), (Object)ops.createString("post_provider"), (Object)this.postProvider.func_218175_a(ops), (Object)ops.createString("torch_provider"), (Object)this.torchProvider.func_218175_a(ops))));
    }

    public static <T> CraftingMonumentFeatureConfig deserialize(Dynamic<T> dyn) {
        BlockState tableState = dyn.get("table_state").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
        BlockStateProvider baseProvider = LOTRFeatures.deserializeBlockProvider(dyn, "base_provider");
        BlockStateProvider postProvider = LOTRFeatures.deserializeBlockProvider(dyn, "post_provider");
        BlockStateProvider torchProvider = LOTRFeatures.deserializeBlockProvider(dyn, "torch_provider");
        return new CraftingMonumentFeatureConfig(tableState, baseProvider, postProvider, torchProvider);
    }
}

