/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import lotr.common.block.CrystalBlock;
import lotr.common.world.gen.feature.CrystalFeatureConfig;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;

public class CrystalFeature
extends Feature<CrystalFeatureConfig> {
    public CrystalFeature(Function<Dynamic<?>, ? extends CrystalFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, CrystalFeatureConfig config) {
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        block0: for (int l = 0; l < config.tries; ++l) {
            int x = pos.func_177958_n() - rand.nextInt(config.xspread) + rand.nextInt(config.xspread);
            int y = pos.func_177956_o() - rand.nextInt(config.yspread) + rand.nextInt(config.yspread);
            int z = pos.func_177952_p() - rand.nextInt(config.zspread) + rand.nextInt(config.zspread);
            movingPos.func_181079_c(x, y, z);
            if (!world.func_175623_d((BlockPos)movingPos)) continue;
            BlockState baseState = config.blockProvider.func_225574_a_(rand, (BlockPos)movingPos);
            List<Direction> dirs = Arrays.asList(Direction.values());
            Collections.shuffle(dirs, rand);
            for (Direction dir : dirs) {
                BlockState placeState = (BlockState)baseState.func_206870_a(CrystalBlock.CRYSTAL_FACING, (Comparable)dir);
                if (!placeState.func_196955_c((IWorldReader)world, (BlockPos)movingPos)) continue;
                world.func_180501_a((BlockPos)movingPos, placeState, 2);
                continue block0;
            }
        }
        return true;
    }
}

