/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import lotr.common.init.LOTRTags;
import lotr.common.world.gen.feature.DeadTreeFeatureConfig;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;

public class DeadTreeFeature
extends AbstractTreeFeature<DeadTreeFeatureConfig> {
    public DeadTreeFeature(Function<Dynamic<?>, ? extends DeadTreeFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> trunk, Set<BlockPos> leaves, MutableBoundingBox bb, DeadTreeFeatureConfig config) {
        int maxCheckWidth;
        int trunkHeight;
        int leafHeight = trunkHeight = config.field_227371_p_ + rand.nextInt(config.heightRandA + 1) + rand.nextInt(config.heightRandB + 1);
        Optional<BlockPos> optional = this.canGrow(world, trunkHeight, leafHeight, maxCheckWidth = 2, pos, config);
        if (!optional.isPresent()) {
            return false;
        }
        BlockPos treePos = optional.get();
        this.setDirtAt(world, treePos.func_177977_b(), treePos);
        for (int y = 0; y < trunkHeight; ++y) {
            this.func_227216_a_(world, rand, treePos.func_177981_b(y), trunk, bb, config);
        }
        if (trunkHeight >= 4) {
            BlockPos.Mutable branchPos = new BlockPos.Mutable();
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                int branchLength = 2 + rand.nextInt(4);
                int branchOut = 0;
                int branchUp = trunkHeight - rand.nextInt(3);
                for (int l = 0; l < branchLength; ++l) {
                    if (rand.nextInt(4) == 0) {
                        ++branchOut;
                    }
                    if (l > 0 && rand.nextInt(3) != 0) {
                        ++branchUp;
                    }
                    branchPos.func_189533_g((Vec3i)treePos.func_177981_b(branchUp).func_177967_a(dir, branchOut));
                    this.setWood(world, rand, (BlockPos)branchPos, trunk, bb, config);
                }
            }
        }
        return true;
    }

    protected boolean setWood(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> set, MutableBoundingBox bb, DeadTreeFeatureConfig config) {
        if (!(DeadTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos) || DeadTreeFeature.func_214576_j((IWorldGenerationBaseReader)world, (BlockPos)pos) || DeadTreeFeature.func_214571_e((IWorldGenerationBaseReader)world, (BlockPos)pos))) {
            return false;
        }
        this.func_227217_a_((IWorldWriter)world, pos, config.woodProvider.func_225574_a_(rand, pos), bb);
        set.add(pos.func_185334_h());
        return true;
    }

    private Optional<BlockPos> canGrow(IWorldGenerationReader world, int trunkHeight, int leafHeight, int maxCheckWidth, BlockPos pos, DeadTreeFeatureConfig config) {
        BlockPos blockpos;
        if (!config.field_227372_q_) {
            int i = world.func_205770_a(Heightmap.Type.OCEAN_FLOOR, pos).func_177956_o();
            int j = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos).func_177956_o();
            blockpos = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
            int maxWaterDepth = 0;
            if (j - i > maxWaterDepth) {
                return Optional.empty();
            }
        } else {
            blockpos = pos;
        }
        if (blockpos.func_177956_o() >= 1 && blockpos.func_177956_o() + trunkHeight + 1 <= world.getMaxHeight()) {
            for (int y = 0; y <= trunkHeight + 1; ++y) {
                int checkWidth = maxCheckWidth;
                BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
                for (int x = -checkWidth; x <= checkWidth; ++x) {
                    for (int z = -checkWidth; z <= checkWidth; ++z) {
                        if (y + blockpos.func_177956_o() >= 0 && y + blockpos.func_177956_o() < world.getMaxHeight()) {
                            blockpos$mutable.func_181079_c(x + blockpos.func_177958_n(), y + blockpos.func_177956_o(), z + blockpos.func_177952_p());
                            boolean ignoreVines = false;
                            if (DeadTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutable) && (ignoreVines || !DeadTreeFeature.func_227222_d_((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutable))) {
                                continue;
                            }
                            return Optional.empty();
                        }
                        return Optional.empty();
                    }
                }
            }
            return this.isValidSurface(world, blockpos.func_177977_b()) && blockpos.func_177956_o() < world.getMaxHeight() - trunkHeight - 1 ? Optional.of(blockpos) : Optional.empty();
        }
        return Optional.empty();
    }

    private boolean isValidSurface(IWorldGenerationReader world, BlockPos pos) {
        return DeadTreeFeature.isSoilOrFarm((IWorldGenerationBaseReader)world, (BlockPos)pos, null) || world.func_217375_a(pos, state -> state.func_203425_a(LOTRTags.Blocks.MORDOR_PLANT_SURFACES));
    }
}

