/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractSmallTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;

public class DesertTreeFeature
extends AbstractSmallTreeFeature<TreeFeatureConfig> {
    public DesertTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> trunk, Set<BlockPos> leaves, MutableBoundingBox bb, TreeFeatureConfig config) {
        int maxCheckWidth;
        int leafHeight;
        int trunkHeight = config.field_227371_p_ + rand.nextInt(config.field_227328_b_ + 1) + rand.nextInt(config.field_227329_c_ + 1);
        Optional<BlockPos> optional = this.func_227212_a_(world, trunkHeight, leafHeight = config.field_227330_d_ >= 0 ? config.field_227330_d_ + rand.nextInt(config.field_227331_f_ + 1) : trunkHeight - (config.field_227334_i_ + rand.nextInt(config.field_227335_j_ + 1)), maxCheckWidth = config.field_227327_a_.func_225573_a_(rand, leafHeight, trunkHeight, config), pos, config);
        if (!optional.isPresent()) {
            return false;
        }
        BlockPos growPos = optional.get();
        this.setDirtAt(world, growPos.func_177977_b(), growPos);
        int trunkTopOffset = config.field_227332_g_ + rand.nextInt(config.field_227333_h_ + 1);
        int branches = 4;
        for (int branch = 0; branch < branches; ++branch) {
            int branchLength = 1 + rand.nextInt(3);
            int branchHeight = trunkHeight - trunkTopOffset - 1 - rand.nextInt(2);
            BlockPos.Mutable branchPos = new BlockPos.Mutable(growPos).func_196234_d(0, branchHeight, 0);
            for (int l = 0; l < branchLength; ++l) {
                if (rand.nextInt(3) != 0) {
                    branchPos.func_189536_c(Direction.UP);
                }
                if (rand.nextInt(3) != 0) {
                    switch (branch) {
                        case 0: {
                            branchPos.func_189536_c(Direction.WEST);
                            break;
                        }
                        case 1: {
                            branchPos.func_189536_c(Direction.EAST);
                            break;
                        }
                        case 2: {
                            branchPos.func_189536_c(Direction.NORTH);
                            break;
                        }
                        case 3: {
                            branchPos.func_189536_c(Direction.SOUTH);
                        }
                    }
                }
                if (!this.func_227216_a_(world, rand, (BlockPos)branchPos, trunk, bb, (BaseTreeFeatureConfig)config)) break;
            }
            int leafStart = 1;
            int leafRangeMin = 0;
            BlockPos.Mutable leafPos = new BlockPos.Mutable();
            for (int y = -leafStart; y <= 1; ++y) {
                int leafRange = leafRangeMin + 1 - y / 2;
                for (int x = -leafRange; x <= leafRange; ++x) {
                    for (int z = -leafRange; z <= leafRange; ++z) {
                        if (Math.abs(x) == leafRange && Math.abs(z) == leafRange && (rand.nextInt(2) == 0 || y == 0)) continue;
                        leafPos.func_189533_g((Vec3i)branchPos).func_196234_d(x, y, z);
                        this.func_227219_b_(world, rand, (BlockPos)leafPos, leaves, bb, (BaseTreeFeatureConfig)config);
                    }
                }
            }
        }
        this.func_227213_a_(world, rand, trunkHeight, growPos, trunkTopOffset, trunk, bb, config);
        return true;
    }

    public Optional<BlockPos> func_227212_a_(IWorldGenerationReader world, int trunkHeight, int leafHeight, int maxCheckWidth, BlockPos pos, TreeFeatureConfig config) {
        BlockPos growPos;
        if (!config.field_227372_q_) {
            int landHeight = world.func_205770_a(Heightmap.Type.OCEAN_FLOOR, pos).func_177956_o();
            int landOrWaterHeight = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos).func_177956_o();
            growPos = new BlockPos(pos.func_177958_n(), landHeight, pos.func_177952_p());
            if (landOrWaterHeight - landHeight > config.field_227336_k_) {
                return Optional.empty();
            }
        } else {
            growPos = pos;
        }
        if (growPos.func_177956_o() >= 1 && growPos.func_177956_o() + trunkHeight + 1 <= world.getMaxHeight()) {
            for (int y = 0; y <= trunkHeight + 1; ++y) {
                int checkWidth = config.field_227327_a_.func_225570_a_(leafHeight, trunkHeight, maxCheckWidth, y);
                BlockPos.Mutable checkPos = new BlockPos.Mutable();
                for (int x = -checkWidth; x <= checkWidth; ++x) {
                    for (int z = -checkWidth; z <= checkWidth; ++z) {
                        if (y + growPos.func_177956_o() >= 0 && y + growPos.func_177956_o() < world.getMaxHeight()) {
                            checkPos.func_181079_c(x + growPos.func_177958_n(), y + growPos.func_177956_o(), z + growPos.func_177952_p());
                            if (DesertTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)checkPos) && (config.field_227337_l_ || !DesertTreeFeature.func_227222_d_((IWorldGenerationBaseReader)world, (BlockPos)checkPos))) {
                                continue;
                            }
                            return Optional.empty();
                        }
                        return Optional.empty();
                    }
                }
            }
            return this.canGrowOn(world, growPos.func_177977_b(), config.getSapling()) && growPos.func_177956_o() < world.getMaxHeight() - trunkHeight - 1 ? Optional.of(growPos) : Optional.empty();
        }
        return Optional.empty();
    }

    private boolean canGrowOn(IWorldGenerationReader world, BlockPos soilPos, IPlantable sapling) {
        if (DesertTreeFeature.isSoilOrFarm((IWorldGenerationBaseReader)world, (BlockPos)soilPos, (IPlantable)sapling)) {
            return true;
        }
        return world.func_217375_a(soilPos, state -> state.func_203425_a(BlockTags.field_203436_u) || state.func_203425_a(Tags.Blocks.SANDSTONE) || state.func_177230_c() == Blocks.field_150348_b);
    }
}

