/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import lotr.common.block.DripstoneBlock;
import net.minecraft.block.BlockState;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class DripstoneFeatureConfig
implements IFeatureConfig {
    public final int tries;
    public final int xspread;
    public final int yspread;
    public final int zspread;
    public final float doubleChance;
    public final BlockState forcedBlockState;

    public DripstoneFeatureConfig(int t, int x, int y, int z, float dc) {
        this(t, x, y, z, dc, null);
    }

    public DripstoneFeatureConfig(int t, int x, int y, int z, float dc, BlockState state) {
        this.tries = t;
        this.xspread = x;
        this.yspread = y;
        this.zspread = z;
        this.doubleChance = dc;
        this.forcedBlockState = state;
    }

    public boolean hasForcedDripstoneState() {
        return this.forcedBlockState != null && this.forcedBlockState.func_177230_c() instanceof DripstoneBlock;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("tries"), ops.createInt(this.tries)).put(ops.createString("xspread"), ops.createInt(this.xspread)).put(ops.createString("yspread"), ops.createInt(this.yspread)).put(ops.createString("zspread"), ops.createInt(this.zspread)).put(ops.createString("double_chance"), ops.createFloat(this.doubleChance));
        if (this.forcedBlockState != null) {
            builder.put(ops.createString("forced_blockstate"), BlockState.func_215689_a(ops, (BlockState)this.forcedBlockState).getValue());
        }
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    public static <T> DripstoneFeatureConfig deserialize(Dynamic<T> dyn) {
        int tries = dyn.get("tries").asInt(0);
        int xspread = dyn.get("xspread").asInt(0);
        int yspread = dyn.get("yspread").asInt(0);
        int zspread = dyn.get("zspread").asInt(0);
        float doubleChance = dyn.get("double_chance").asFloat(0.0f);
        BlockState state = BlockState.func_215698_a((Dynamic)dyn.get("forced_blockstate").orElseEmptyMap());
        DripstoneFeatureConfig config = new DripstoneFeatureConfig(tries, xspread, yspread, zspread, doubleChance, state);
        return config;
    }
}

