/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.List;
import java.util.Map;
import lotr.common.world.gen.feature.LOTRFeatures;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraftforge.common.IPlantable;

public class ExtendedTreeConfig
extends TreeFeatureConfig {
    public final BlockStateProvider woodProvider;
    public final boolean isMirky;
    public final BlockStateProvider strippedLogProvider;
    public final BlockStateProvider branchProvider;

    public ExtendedTreeConfig(BlockStateProvider trunk, BlockStateProvider wood, BlockStateProvider leaves, FoliagePlacer fol, List<TreeDecorator> decos, int bh, int ha, int hb, int th, int thr, int tto, int ttor, int fh, int fhr, int mWater, boolean ignoreVs, boolean mirky, BlockStateProvider strippedLog, BlockStateProvider branch) {
        super(trunk, leaves, fol, decos, bh, ha, hb, th, thr, tto, ttor, fh, fhr, mWater, ignoreVs);
        this.woodProvider = wood;
        this.isMirky = mirky;
        this.strippedLogProvider = strippedLog;
        this.branchProvider = branch;
    }

    public ExtendedTreeConfig(TreeFeatureConfig base, BlockStateProvider wood, boolean mirky, BlockStateProvider strippedLog, BlockStateProvider branch) {
        this(base.field_227368_m_, wood, base.field_227369_n_, base.field_227327_a_, base.field_227370_o_, base.field_227371_p_, base.field_227328_b_, base.field_227329_c_, base.field_227330_d_, base.field_227331_f_, base.field_227332_g_, base.field_227333_h_, base.field_227334_i_, base.field_227335_j_, base.field_227336_k_, base.field_227337_l_, mirky, strippedLog, branch);
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("wood_provider"), this.woodProvider.func_218175_a(ops));
        builder.put(ops.createString("mirky"), ops.createBoolean(this.isMirky));
        if (this.strippedLogProvider != null) {
            builder.put(ops.createString("stripped_log_provider"), this.strippedLogProvider.func_218175_a(ops));
        }
        if (this.branchProvider != null) {
            builder.put(ops.createString("branch_provider"), this.branchProvider.func_218175_a(ops));
        }
        Dynamic dyn = new Dynamic(ops, ops.createMap((Map)builder.build()));
        return dyn.merge(super.func_214634_a(ops));
    }

    public static <T> ExtendedTreeConfig deserializeExt(Dynamic<T> dyn) {
        TreeFeatureConfig baseConfig = TreeFeatureConfig.func_227338_a_(dyn);
        BlockStateProvider woodProvider = LOTRFeatures.deserializeBlockProvider(dyn, "wood_provider");
        boolean isMirky = dyn.get("mirky").asBoolean(false);
        BlockStateProvider strippedWoodProvider = null;
        BlockStateProvider branchProvider = null;
        if (dyn.get("stripped_log_provider").get().isPresent()) {
            strippedWoodProvider = LOTRFeatures.deserializeBlockProvider(dyn, "stripped_log_provider");
        }
        if (dyn.get("branch_provider").get().isPresent()) {
            branchProvider = LOTRFeatures.deserializeBlockProvider(dyn, "branch_provider");
        }
        return new ExtendedTreeConfig(baseConfig, woodProvider, isMirky, strippedWoodProvider, branchProvider);
    }

    public static class Builder
    extends TreeFeatureConfig.Builder {
        private final BlockStateProvider woodProvider;
        private boolean isMirky = false;
        private BlockStateProvider strippedLogProvider;
        private BlockStateProvider branchProvider;

        public Builder(BlockStateProvider trunk, BlockStateProvider wood, BlockStateProvider leaves, FoliagePlacer fol) {
            super(trunk, leaves, fol);
            this.woodProvider = wood;
        }

        public Builder decorators(List<TreeDecorator> decos) {
            super.func_227353_a_(decos);
            return this;
        }

        public Builder baseHeight(int bh) {
            super.func_225569_d_(bh);
            return this;
        }

        public Builder heightRandA(int ha) {
            super.func_227354_b_(ha);
            return this;
        }

        public Builder heightRandB(int hb) {
            super.func_227355_c_(hb);
            return this;
        }

        public Builder trunkHeight(int th) {
            super.func_227356_e_(th);
            return this;
        }

        public Builder trunkHeightRandom(int thr) {
            super.func_227357_f_(thr);
            return this;
        }

        public Builder trunkTopOffset(int tto) {
            super.func_227358_g_(tto);
            return this;
        }

        public Builder trunkTopOffsetRandom(int ttor) {
            super.func_227359_h_(ttor);
            return this;
        }

        public Builder foliageHeight(int folH) {
            super.func_227360_i_(folH);
            return this;
        }

        public Builder foliageHeightRandom(int folHR) {
            super.func_227361_j_(folHR);
            return this;
        }

        public Builder maxWaterDepth(int wDepth) {
            super.func_227362_k_(wDepth);
            return this;
        }

        public Builder ignoreVines() {
            super.func_227352_a_();
            return this;
        }

        public Builder setSapling(IPlantable sapling) {
            super.setSapling(sapling);
            return this;
        }

        public Builder isMirky(boolean flag) {
            this.isMirky = flag;
            return this;
        }

        public Builder strippedLog(BlockStateProvider strippedLog) {
            this.strippedLogProvider = strippedLog;
            return this;
        }

        public Builder branch(BlockStateProvider branch) {
            this.branchProvider = branch;
            return this;
        }

        public ExtendedTreeConfig build() {
            return new ExtendedTreeConfig(super.func_225568_b_(), this.woodProvider, this.isMirky, this.strippedLogProvider, this.branchProvider);
        }
    }
}

