/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import lotr.common.world.gen.feature.ExtendedTreeConfig;
import lotr.common.world.gen.feature.LOTRFeatures;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractSmallTreeFeature;

public abstract class ExtendedTreeFeature<T extends ExtendedTreeConfig>
extends AbstractSmallTreeFeature<T> {
    public static final int MAX_LEAF_DISTANCE = 7;
    public static final int OLD_MAX_LEAF_DISTANCE = 4;

    public ExtendedTreeFeature(Function<Dynamic<?>, ? extends T> configFactory) {
        super(configFactory);
    }

    protected boolean placeWood(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> trunk, MutableBoundingBox bb, ExtendedTreeConfig config, Direction.Axis axis) {
        if (!(ExtendedTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos) || ExtendedTreeFeature.func_214576_j((IWorldGenerationBaseReader)world, (BlockPos)pos) || ExtendedTreeFeature.func_214571_e((IWorldGenerationBaseReader)world, (BlockPos)pos))) {
            return false;
        }
        this.func_227217_a_((IWorldWriter)world, pos, (BlockState)config.woodProvider.func_225574_a_(rand, pos).func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)axis), bb);
        trunk.add(pos.func_185334_h());
        return true;
    }

    protected boolean placeStrippedLog(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> trunk, MutableBoundingBox bb, ExtendedTreeConfig config, Direction.Axis axis) {
        if (!(ExtendedTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos) || ExtendedTreeFeature.func_214576_j((IWorldGenerationBaseReader)world, (BlockPos)pos) || ExtendedTreeFeature.func_214571_e((IWorldGenerationBaseReader)world, (BlockPos)pos))) {
            return false;
        }
        this.func_227217_a_((IWorldWriter)world, pos, (BlockState)config.strippedLogProvider.func_225574_a_(rand, pos).func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)axis), bb);
        trunk.add(pos.func_185334_h());
        return true;
    }

    protected boolean placeBranch(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> trunk, MutableBoundingBox bb, ExtendedTreeConfig config) {
        if (!(ExtendedTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos) || ExtendedTreeFeature.func_214576_j((IWorldGenerationBaseReader)world, (BlockPos)pos) || ExtendedTreeFeature.func_214571_e((IWorldGenerationBaseReader)world, (BlockPos)pos))) {
            return false;
        }
        BlockState placeState = config.branchProvider.func_225574_a_(rand, pos);
        if (placeState.func_196959_b((IProperty)BlockStateProperties.field_208198_y)) {
            placeState = (BlockState)placeState.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_217375_a(pos, state -> state.func_204520_s().func_206886_c() == Fluids.field_204546_a)));
        }
        this.func_227217_a_((IWorldWriter)world, pos, placeState, bb);
        trunk.add(pos.func_185334_h());
        return true;
    }

    protected void growRootsDown(IWorldGenerationReader world, Random rand, BlockPos.Mutable rootPos, int rootLength, Set<BlockPos> trunk, MutableBoundingBox bb, ExtendedTreeConfig config) {
        this.growRootsDownBranchingOut(world, rand, rootPos, rootLength, null, 0, trunk, bb, config);
    }

    protected void growRootsDownBranchingOut(IWorldGenerationReader world, Random rand, BlockPos.Mutable rootPos, int rootLength, Direction outwardsDir, int outwardsInterval, Set<BlockPos> trunk, MutableBoundingBox bb, ExtendedTreeConfig config) {
        int outwardsStartAt;
        int roots = 0;
        int n = outwardsStartAt = outwardsInterval > 0 ? rand.nextInt(outwardsInterval) : 0;
        while (rootPos.func_177956_o() >= 0 && (this.canLeavesReplace(world, (BlockPos)rootPos, config) || world.func_217375_a((BlockPos)rootPos, state -> state.func_177230_c() == Blocks.field_150355_j)) && this.placeBranch(world, rand, (BlockPos)rootPos, trunk, bb, config)) {
            if (world instanceof IWorld) {
                IWorld worldProper = (IWorld)world;
                BlockState placedState = worldProper.func_180495_p((BlockPos)rootPos);
                worldProper.func_180501_a((BlockPos)rootPos, LOTRFeatures.getBlockStateInContext(placedState, worldProper, (BlockPos)rootPos), 19);
                this.updateNeighboursAfterGeneration(worldProper, (BlockPos)rootPos);
            }
            if (outwardsDir != null && outwardsInterval > 0 && roots % outwardsInterval == outwardsStartAt) {
                rootPos.func_189536_c(outwardsDir);
            } else {
                rootPos.func_189536_c(Direction.DOWN);
            }
            if (++roots <= rootLength) continue;
            break;
        }
    }

    protected void growRootsDownAndThenOut(IWorldGenerationReader world, Random rand, BlockPos.Mutable rootPos, int rootLength, Direction outwardsDir, int maxOut, Set<BlockPos> trunk, MutableBoundingBox bb, ExtendedTreeConfig config) {
        int roots = 0;
        int numOut = 0;
        while (rootPos.func_177956_o() >= 0 && (this.canLeavesReplace(world, (BlockPos)rootPos, config) || world.func_217375_a((BlockPos)rootPos, state -> state.func_177230_c() == Blocks.field_150355_j)) && this.placeBranch(world, rand, (BlockPos)rootPos, trunk, bb, config)) {
            if (world instanceof IWorld) {
                IWorld worldProper = (IWorld)world;
                BlockState placedState = worldProper.func_180495_p((BlockPos)rootPos);
                worldProper.func_180501_a((BlockPos)rootPos, LOTRFeatures.getBlockStateInContext(placedState, worldProper, (BlockPos)rootPos), 19);
                this.updateNeighboursAfterGeneration(worldProper, (BlockPos)rootPos);
            }
            if (world.func_217375_a(rootPos.func_177977_b(), BlockState::func_200132_m)) {
                rootPos.func_189536_c(outwardsDir);
                if (++numOut > maxOut) {
                    break;
                }
            } else {
                rootPos.func_189536_c(Direction.DOWN);
            }
            if (++roots <= rootLength) continue;
            break;
        }
    }

    private void updateNeighboursAfterGeneration(IWorld world, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            BlockPos adjacentPos = pos.func_177972_a(dir);
            BlockState state = world.func_180495_p(adjacentPos);
            BlockState updatedState = LOTRFeatures.getBlockStateInContext(state, world, adjacentPos);
            world.func_180501_a(adjacentPos, updatedState, 19);
        }
    }

    protected boolean canLeavesReplace(IWorldGenerationReader world, BlockPos pos, ExtendedTreeConfig config) {
        return ExtendedTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)pos) && (config.field_227337_l_ || !ExtendedTreeFeature.func_227222_d_((IWorldGenerationBaseReader)world, (BlockPos)pos));
    }
}

