/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import lotr.common.block.FallenLeavesBlock;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FallenLeavesFeature
extends Feature<NoFeatureConfig> {
    public FallenLeavesFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockState fallenLeavesState = null;
        int searchTries = 40;
        int searchXRange = 6;
        int searchYRangeUp = 12;
        int searchZRange = 6;
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        for (int i = 0; i < searchTries; ++i) {
            int x = MathHelper.func_76136_a((Random)rand, (int)(-searchXRange), (int)searchXRange);
            int y = rand.nextInt(searchYRangeUp + 1);
            int z = MathHelper.func_76136_a((Random)rand, (int)(-searchZRange), (int)searchZRange);
            movingPos.func_189533_g((Vec3i)pos).func_196234_d(x, y, z);
            BlockState state = world.func_180495_p((BlockPos)movingPos);
            FallenLeavesBlock fallenLeavesBlock = FallenLeavesBlock.getFallenLeavesFor(state.func_177230_c());
            if (fallenLeavesBlock == null) continue;
            fallenLeavesState = fallenLeavesBlock.func_176223_P();
            break;
        }
        if (fallenLeavesState == null) {
            return false;
        }
        int placeTries = 64;
        int placeXRange = 5;
        int placeYRange = 3;
        int placeZRange = 5;
        for (int i = 0; i < placeTries; ++i) {
            int x = MathHelper.func_76136_a((Random)rand, (int)(-placeXRange), (int)placeXRange);
            int y = MathHelper.func_76136_a((Random)rand, (int)(-placeYRange), (int)placeYRange);
            int z = MathHelper.func_76136_a((Random)rand, (int)(-placeZRange), (int)placeZRange);
            movingPos.func_189533_g((Vec3i)pos).func_196234_d(x, y, z);
            BlockState currentState = world.func_180495_p((BlockPos)movingPos);
            if (!fallenLeavesState.func_196955_c((IWorldReader)world, (BlockPos)movingPos) || !currentState.func_185904_a().func_76222_j() || !currentState.func_204520_s().func_206888_e()) continue;
            world.func_180501_a((BlockPos)movingPos, fallenLeavesState, 2);
        }
        return true;
    }
}

