/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import lotr.common.world.gen.feature.ExtendedTreeConfig;
import lotr.common.world.gen.feature.ExtendedTreeFeature;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class FangornTreeFeature
extends ExtendedTreeFeature<ExtendedTreeConfig> {
    private float heightFactor = 1.0f;
    private boolean generateLeaves = true;

    public FangornTreeFeature(Function<Dynamic<?>, ? extends ExtendedTreeConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> trunk, Set<BlockPos> leaves, MutableBoundingBox bb, ExtendedTreeConfig config) {
        float randF = MathHelper.func_151240_a((Random)rand, (float)0.5f, (float)1.0f);
        int height = (int)(randF * 40.0f * this.heightFactor);
        int trunkRadiusMin = (int)(randF * 5.0f);
        int trunkRadiusMax = trunkRadiusMin + 4;
        int xSlope = MathHelper.func_76136_a((Random)rand, (int)4, (int)10) * (rand.nextBoolean() ? -1 : 1);
        int zSlope = MathHelper.func_76136_a((Random)rand, (int)4, (int)10) * (rand.nextBoolean() ? -1 : 1);
        int trunkHeight = height;
        int leafHeight = height;
        int maxCheckWidth = trunkRadiusMax;
        Optional<BlockPos> canGrow = this.func_227212_a_(world, trunkHeight, leafHeight, maxCheckWidth, pos, config);
        if (!canGrow.isPresent()) {
            return false;
        }
        BlockPos growPos = canGrow.get();
        BlockPos.Mutable offsetCentrePos = new BlockPos.Mutable(growPos);
        HashSet<BlockPos> strippedLogTrunkPositions = new HashSet<BlockPos>();
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        for (int y = 0; y < height; ++y) {
            float heightF = (float)y / (float)height;
            int width = trunkRadiusMax - (int)(heightF * (float)(trunkRadiusMax - trunkRadiusMin));
            for (int x = -width; x <= width; ++x) {
                for (int z = -width; z <= width; ++z) {
                    movingPos.func_189533_g((Vec3i)offsetCentrePos).func_196234_d(x, y, z);
                    if (x * x + z * z >= width * width) continue;
                    if (this.placeStrippedLog(world, rand, (BlockPos)movingPos, trunk, bb, config, Direction.Axis.Y)) {
                        strippedLogTrunkPositions.add(movingPos.func_185334_h());
                    }
                    if (y != 0) continue;
                    this.setDirtAt(world, movingPos.func_177977_b(), (BlockPos)movingPos);
                    BlockPos.Mutable woodBelowPos = new BlockPos.Mutable(movingPos.func_177977_b());
                    int woodBelow = 0;
                    int maxWoodBelow = 6 + rand.nextInt(5);
                    while (woodBelowPos.func_177956_o() >= 0 && this.placeStrippedLog(world, rand, (BlockPos)woodBelowPos, trunk, bb, config, Direction.Axis.Y)) {
                        strippedLogTrunkPositions.add(woodBelowPos.func_185334_h());
                        this.setDirtAt(world, woodBelowPos.func_177977_b(), (BlockPos)woodBelowPos);
                        woodBelowPos.func_189536_c(Direction.DOWN);
                        if (++woodBelow <= maxWoodBelow) continue;
                    }
                }
            }
            if (y % xSlope == 0) {
                if (xSlope > 0) {
                    offsetCentrePos.func_189536_c(Direction.EAST);
                } else if (xSlope < 0) {
                    offsetCentrePos.func_189536_c(Direction.WEST);
                }
            }
            if (y % zSlope != 0) continue;
            if (zSlope > 0) {
                offsetCentrePos.func_189536_c(Direction.SOUTH);
                continue;
            }
            if (zSlope >= 0) continue;
            offsetCentrePos.func_189536_c(Direction.NORTH);
        }
        long timeBeforeTrunk = System.nanoTime();
        Predicate<BlockState> notWood = state -> !state.func_203425_a(BlockTags.field_200031_h);
        block4: for (BlockPos strippedPos : strippedLogTrunkPositions) {
            for (Direction checkDir : Direction.values()) {
                if (!world.func_217375_a(strippedPos.func_177972_a(checkDir), notWood)) continue;
                world.func_180501_a(strippedPos, config.woodProvider.func_225574_a_(rand, strippedPos), 19);
                continue block4;
            }
        }
        long timeAfterTrunk = System.nanoTime();
        int angle = 0;
        while (angle < 360) {
            float angleR = (float)Math.toRadians(angle += 10 + rand.nextInt(20));
            float sin = MathHelper.func_76126_a((float)angleR);
            float cos = MathHelper.func_76134_b((float)angleR);
            int boughLength = 12 + rand.nextInt(10);
            int boughThickness = Math.round((float)boughLength / 25.0f * 1.5f);
            int boughBaseHeight = MathHelper.func_76141_d((float)((float)height * (0.9f + rand.nextFloat() * 0.1f)));
            int boughHeight = 3 + rand.nextInt(4);
            for (int l = 0; l < boughLength; ++l) {
                int x = Math.round(cos * (float)l);
                int z = Math.round(sin * (float)l);
                int y = boughBaseHeight + Math.round((float)l / (float)boughLength * (float)boughHeight);
                int range = boughThickness - Math.round((float)l / (float)boughLength * (float)boughThickness * 0.5f);
                for (int x1 = -range; x1 <= range; ++x1) {
                    for (int y1 = -range; y1 <= range; ++y1) {
                        for (int z1 = -range; z1 <= range; ++z1) {
                            movingPos.func_189533_g((Vec3i)offsetCentrePos).func_196234_d(x + x1, y + y1, z + z1);
                            this.placeWood(world, rand, (BlockPos)movingPos, trunk, bb, config, Direction.Axis.Y);
                        }
                    }
                }
                int branch_angle = angle + rand.nextInt(360);
                float branch_angleR = (float)Math.toRadians(branch_angle);
                float branch_sin = MathHelper.func_76126_a((float)branch_angleR);
                float branch_cos = MathHelper.func_76134_b((float)branch_angleR);
                int branchLength = 7 + rand.nextInt(6);
                int branchHeight = rand.nextInt(6);
                int leafRange = 3;
                for (int l1 = 0; l1 < branchLength; ++l1) {
                    int x1 = x + Math.round(branch_cos * (float)l1);
                    int z1 = z + Math.round(branch_sin * (float)l1);
                    int y1 = y + Math.round((float)l1 / (float)branchLength * (float)branchHeight);
                    for (int y2 = 0; y2 >= -1; --y2) {
                        movingPos.func_189533_g((Vec3i)offsetCentrePos).func_196234_d(x1, y1 + y2, z1);
                        this.placeWood(world, rand, (BlockPos)movingPos, trunk, bb, config, Direction.Axis.Y);
                    }
                    if (!this.generateLeaves || l1 != branchLength - 1) continue;
                    for (int x2 = -leafRange; x2 <= leafRange; ++x2) {
                        for (int y2 = -leafRange; y2 <= leafRange; ++y2) {
                            for (int z2 = -leafRange; z2 <= leafRange; ++z2) {
                                int dSq = x2 * x2 + y2 * y2 + z2 * z2;
                                if (dSq >= (leafRange - 1) * (leafRange - 1) && (dSq >= leafRange * leafRange || rand.nextInt(3) == 0)) continue;
                                movingPos.func_189533_g((Vec3i)offsetCentrePos).func_196234_d(x1 + x2, y1 + y2, z1 + z2);
                                this.func_227219_b_(world, rand, (BlockPos)movingPos, leaves, bb, (BaseTreeFeatureConfig)config);
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    public Optional<BlockPos> func_227212_a_(IWorldGenerationReader world, int trunkHeight, int leafHeight, int maxCheckWidth, BlockPos pos, TreeFeatureConfig config) {
        BlockPos growPos;
        if (!config.field_227372_q_) {
            int landHeight = world.func_205770_a(Heightmap.Type.OCEAN_FLOOR, pos).func_177956_o();
            int landOrWaterHeight = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos).func_177956_o();
            growPos = new BlockPos(pos.func_177958_n(), landHeight, pos.func_177952_p());
            if (landOrWaterHeight - landHeight > config.field_227336_k_) {
                return Optional.empty();
            }
        } else {
            growPos = pos;
        }
        if (growPos.func_177956_o() >= 1 && growPos.func_177956_o() + trunkHeight + 1 <= world.getMaxHeight()) {
            for (int y = 0; y <= trunkHeight + 1; ++y) {
                int checkWidth = maxCheckWidth;
                BlockPos.Mutable checkPos = new BlockPos.Mutable();
                for (int x = -checkWidth; x <= checkWidth; ++x) {
                    for (int z = -checkWidth; z <= checkWidth; ++z) {
                        if (y + growPos.func_177956_o() >= 0 && y + growPos.func_177956_o() < world.getMaxHeight()) {
                            checkPos.func_181079_c(x + growPos.func_177958_n(), y + growPos.func_177956_o(), z + growPos.func_177952_p());
                            if (FangornTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)checkPos) && (config.field_227337_l_ || !FangornTreeFeature.func_227222_d_((IWorldGenerationBaseReader)world, (BlockPos)checkPos))) {
                                continue;
                            }
                            return Optional.empty();
                        }
                        return Optional.empty();
                    }
                }
            }
            return FangornTreeFeature.isSoilOrFarm((IWorldGenerationBaseReader)world, (BlockPos)growPos.func_177977_b(), (IPlantable)config.getSapling()) && growPos.func_177956_o() < world.getMaxHeight() - trunkHeight - 1 ? Optional.of(growPos) : Optional.empty();
        }
        return Optional.empty();
    }
}

