/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class GrassPatchFeatureConfig
implements IFeatureConfig {
    public final List<BlockState> targetStates;
    public final int minRadius;
    public final int maxRadius;
    public final int minDepth;
    public final int maxDepth;

    public GrassPatchFeatureConfig(List<BlockState> states, int rMin, int rMax, int dMin, int dMax) {
        this.targetStates = states;
        this.minRadius = rMin;
        this.maxRadius = rMax;
        this.minDepth = dMin;
        this.maxDepth = dMax;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("block_targets"), (Object)ops.createList(this.targetStates.stream().map(state -> BlockState.func_215689_a((DynamicOps)ops, (BlockState)state).getValue())), (Object)ops.createString("min_radius"), (Object)ops.createInt(this.minRadius), (Object)ops.createString("max_radius"), (Object)ops.createInt(this.maxRadius), (Object)ops.createString("min_depth"), (Object)ops.createInt(this.minDepth), (Object)ops.createString("max_depth"), (Object)ops.createInt(this.maxDepth))));
    }

    public static <T> GrassPatchFeatureConfig deserialize(Dynamic<T> dyn) {
        ArrayList targetStates = Lists.newArrayList((Iterable)dyn.get("block_targets").asList(BlockState::func_215698_a));
        int minRadius = dyn.get("min_radius").asInt(0);
        int maxRadius = dyn.get("max_radius").asInt(0);
        int minDepth = dyn.get("min_depth").asInt(0);
        int maxDepth = dyn.get("max_depth").asInt(0);
        return new GrassPatchFeatureConfig(targetStates, minRadius, maxRadius, minDepth, maxDepth);
    }
}

