/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.function.Function;
import lotr.common.init.LOTRTags;
import lotr.common.world.gen.feature.BoughsTreeFeature;
import lotr.common.world.gen.feature.BoulderFeature;
import lotr.common.world.gen.feature.BoulderFeatureConfig;
import lotr.common.world.gen.feature.CedarTreeFeature;
import lotr.common.world.gen.feature.CobwebFeature;
import lotr.common.world.gen.feature.CobwebFeatureConfig;
import lotr.common.world.gen.feature.CraftingMonumentFeature;
import lotr.common.world.gen.feature.CraftingMonumentFeatureConfig;
import lotr.common.world.gen.feature.CrystalFeature;
import lotr.common.world.gen.feature.CrystalFeatureConfig;
import lotr.common.world.gen.feature.DeadTreeFeature;
import lotr.common.world.gen.feature.DeadTreeFeatureConfig;
import lotr.common.world.gen.feature.DesertTreeFeature;
import lotr.common.world.gen.feature.DripstoneFeature;
import lotr.common.world.gen.feature.DripstoneFeatureConfig;
import lotr.common.world.gen.feature.ExtendedTreeConfig;
import lotr.common.world.gen.feature.FallenLeavesFeature;
import lotr.common.world.gen.feature.FallenLogFeature;
import lotr.common.world.gen.feature.FallenLogFeatureConfig;
import lotr.common.world.gen.feature.FangornTreeFeature;
import lotr.common.world.gen.feature.GrassPatchFeature;
import lotr.common.world.gen.feature.GrassPatchFeatureConfig;
import lotr.common.world.gen.feature.LatitudeBasedFeature;
import lotr.common.world.gen.feature.LatitudeBasedFeatureConfig;
import lotr.common.world.gen.feature.LeafBushesFeature;
import lotr.common.world.gen.feature.MirkOakTreeFeature;
import lotr.common.world.gen.feature.MordorMossFeature;
import lotr.common.world.gen.feature.MordorMossFeatureConfig;
import lotr.common.world.gen.feature.ReedsFeature;
import lotr.common.world.gen.feature.ReedsFeatureConfig;
import lotr.common.world.gen.feature.TerrainSharpenFeature;
import lotr.common.world.gen.feature.TerrainSharpenFeatureConfig;
import lotr.common.world.gen.feature.TreeTorchesFeature;
import lotr.common.world.gen.feature.UnderwaterSpongeFeature;
import lotr.common.world.gen.feature.WeightedRandomFeature;
import lotr.common.world.gen.feature.WeightedRandomFeatureConfig;
import lotr.common.world.gen.placement.AtSurfaceLayerLimitedWithExtra;
import lotr.common.world.gen.placement.AtSurfaceLayerLimitedWithExtraConfig;
import lotr.common.world.gen.placement.ChanceHeightBiasedRange;
import lotr.common.world.gen.placement.TreeClusters;
import lotr.common.world.gen.placement.TreeClustersConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateProvidingFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.placement.ChanceRangeConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class LOTRFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"lotr");
    public static final DeferredRegister<Placement<?>> PLACEMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.DECORATORS, (String)"lotr");
    public static final RegistryObject<WeightedRandomFeature> WEIGHTED_RANDOM = FEATURES.register("weighted_random", () -> LOTRFeatures.weightedRandom());
    public static final RegistryObject<MordorMossFeature> MORDOR_MOSS = FEATURES.register("mordor_moss", () -> LOTRFeatures.mordorMoss());
    public static final RegistryObject<BoulderFeature> BOULDER = FEATURES.register("boulder", () -> LOTRFeatures.boulder());
    public static final RegistryObject<DeadTreeFeature> DEAD_TREE = FEATURES.register("dead_tree", () -> LOTRFeatures.deadTree());
    public static final RegistryObject<DripstoneFeature> DRIPSTONE = FEATURES.register("dripstone", () -> LOTRFeatures.dripstone());
    public static final RegistryObject<CobwebFeature> COBWEBS = FEATURES.register("cobwebs", () -> LOTRFeatures.cobwebs());
    public static final RegistryObject<BoughsTreeFeature> BOUGHS_TREE = FEATURES.register("boughs_tree", () -> LOTRFeatures.boughsTree());
    public static final RegistryObject<TerrainSharpenFeature> TERRAIN_SHARPEN = FEATURES.register("terrain_sharpen", () -> LOTRFeatures.terrainSharpen());
    public static final RegistryObject<GrassPatchFeature> GRASS_PATCH = FEATURES.register("grass_patch", () -> LOTRFeatures.grassPatch());
    public static final RegistryObject<TreeTorchesFeature> TREE_TORCHES = FEATURES.register("tree_torches", () -> LOTRFeatures.treeTorches());
    public static final RegistryObject<CraftingMonumentFeature> CRAFTING_MONUMENT = FEATURES.register("crafting_monument", () -> LOTRFeatures.craftingMonument());
    public static final RegistryObject<CedarTreeFeature> CEDAR_TREE = FEATURES.register("cedar_tree", () -> LOTRFeatures.cedarTree());
    public static final RegistryObject<DesertTreeFeature> DESERT_TREE = FEATURES.register("desert_tree", () -> LOTRFeatures.desertTree());
    public static final RegistryObject<CrystalFeature> CRYSTALS = FEATURES.register("crystals", () -> LOTRFeatures.crystals());
    public static final RegistryObject<MirkOakTreeFeature> MIRK_OAK_TREE = FEATURES.register("mirk_oak_tree", () -> LOTRFeatures.mirkOakTree());
    public static final RegistryObject<FangornTreeFeature> FANGORN_TREE = FEATURES.register("fangorn_tree", () -> LOTRFeatures.fangornTree());
    public static final RegistryObject<LatitudeBasedFeature> LATITUDE_BASED = FEATURES.register("latitude_based", () -> LOTRFeatures.latitudeBased());
    public static final RegistryObject<LeafBushesFeature> LEAF_BUSHES = FEATURES.register("leaf_bushes", () -> LOTRFeatures.leafBushes());
    public static final RegistryObject<FallenLogFeature> FALLEN_LOG = FEATURES.register("fallen_log", () -> LOTRFeatures.fallenLog());
    public static final RegistryObject<ReedsFeature> REEDS = FEATURES.register("reeds", () -> LOTRFeatures.reeds());
    public static final RegistryObject<UnderwaterSpongeFeature> UNDERWATER_SPONGE = FEATURES.register("underwater_sponge", () -> LOTRFeatures.underwaterSponge());
    public static final RegistryObject<FallenLeavesFeature> FALLEN_LEAVES = FEATURES.register("fallen_leaves", () -> LOTRFeatures.fallenLeaves());
    public static final RegistryObject<AtSurfaceLayerLimitedWithExtra> COUNT_EXTRA_HEIGHTMAP_LIMITED = PLACEMENTS.register("count_extra_heightmap_limited", () -> LOTRFeatures.countExtraHeightmapLimited());
    public static final RegistryObject<ChanceHeightBiasedRange> CHANCE_BIASED_RANGE = PLACEMENTS.register("chance_biased_range", () -> LOTRFeatures.chanceBiasedRange());
    public static final RegistryObject<TreeClusters> TREE_CLUSTERS = PLACEMENTS.register("tree_clusters", () -> LOTRFeatures.treeClusters());

    public static void register() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        FEATURES.register(bus);
        PLACEMENTS.register(bus);
    }

    public static WeightedRandomFeature weightedRandom() {
        return new WeightedRandomFeature(WeightedRandomFeatureConfig::deserialize);
    }

    public static MordorMossFeature mordorMoss() {
        return new MordorMossFeature(MordorMossFeatureConfig::deserialize);
    }

    public static BoulderFeature boulder() {
        return new BoulderFeature(BoulderFeatureConfig::deserialize);
    }

    public static DeadTreeFeature deadTree() {
        return new DeadTreeFeature(DeadTreeFeatureConfig::deserialize);
    }

    public static DripstoneFeature dripstone() {
        return new DripstoneFeature(DripstoneFeatureConfig::deserialize);
    }

    public static CobwebFeature cobwebs() {
        return new CobwebFeature(CobwebFeatureConfig::deserialize);
    }

    public static BoughsTreeFeature boughsTree() {
        return new BoughsTreeFeature((Function<Dynamic<?>, ? extends ExtendedTreeConfig>)((Function<Dynamic<?>, ExtendedTreeConfig>)ExtendedTreeConfig::deserializeExt));
    }

    public static TerrainSharpenFeature terrainSharpen() {
        return new TerrainSharpenFeature(TerrainSharpenFeatureConfig::deserialize);
    }

    public static GrassPatchFeature grassPatch() {
        return new GrassPatchFeature(GrassPatchFeatureConfig::deserialize);
    }

    public static TreeTorchesFeature treeTorches() {
        return new TreeTorchesFeature(BlockStateProvidingFeatureConfig::func_227269_a_);
    }

    public static CraftingMonumentFeature craftingMonument() {
        return new CraftingMonumentFeature(CraftingMonumentFeatureConfig::deserialize);
    }

    public static CedarTreeFeature cedarTree() {
        return new CedarTreeFeature((Function<Dynamic<?>, ? extends ExtendedTreeConfig>)((Function<Dynamic<?>, ExtendedTreeConfig>)ExtendedTreeConfig::deserializeExt));
    }

    public static DesertTreeFeature desertTree() {
        return new DesertTreeFeature(TreeFeatureConfig::func_227338_a_);
    }

    public static CrystalFeature crystals() {
        return new CrystalFeature(CrystalFeatureConfig::deserialize);
    }

    public static MirkOakTreeFeature mirkOakTree() {
        return new MirkOakTreeFeature((Function<Dynamic<?>, ? extends ExtendedTreeConfig>)((Function<Dynamic<?>, ExtendedTreeConfig>)ExtendedTreeConfig::deserializeExt));
    }

    public static FangornTreeFeature fangornTree() {
        return new FangornTreeFeature((Function<Dynamic<?>, ? extends ExtendedTreeConfig>)((Function<Dynamic<?>, ExtendedTreeConfig>)ExtendedTreeConfig::deserializeExt));
    }

    public static LatitudeBasedFeature latitudeBased() {
        return new LatitudeBasedFeature(LatitudeBasedFeatureConfig::deserialize);
    }

    public static LeafBushesFeature leafBushes() {
        return new LeafBushesFeature(NoFeatureConfig::func_214639_a);
    }

    public static FallenLogFeature fallenLog() {
        return new FallenLogFeature(FallenLogFeatureConfig::deserialize);
    }

    public static ReedsFeature reeds() {
        return new ReedsFeature(ReedsFeatureConfig::deserialize);
    }

    public static UnderwaterSpongeFeature underwaterSponge() {
        return new UnderwaterSpongeFeature(BlockClusterFeatureConfig::func_227300_a_);
    }

    public static FallenLeavesFeature fallenLeaves() {
        return new FallenLeavesFeature(NoFeatureConfig::func_214639_a);
    }

    public static AtSurfaceLayerLimitedWithExtra countExtraHeightmapLimited() {
        return new AtSurfaceLayerLimitedWithExtra(AtSurfaceLayerLimitedWithExtraConfig::deserialize);
    }

    public static ChanceHeightBiasedRange chanceBiasedRange() {
        return new ChanceHeightBiasedRange(ChanceRangeConfig::func_214732_a);
    }

    public static TreeClusters treeClusters() {
        return new TreeClusters(TreeClustersConfig::deserialize);
    }

    public static boolean isSurfaceBlock(IWorld world, BlockPos pos) {
        return LOTRFeatures.isSurfaceBlock(world, pos, 0);
    }

    private static boolean isSurfaceBlock(IWorld world, BlockPos pos, int recursion) {
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76224_d()) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Biome biome = world.func_226691_t_(pos);
        ConfiguredSurfaceBuilder surface = biome.func_205401_q();
        if (block == surface.field_215454_b.func_204108_a().func_177230_c() || block == surface.field_215454_b.func_204109_b().func_177230_c()) {
            return true;
        }
        if (block.func_203417_a(BlockTags.field_203436_u) || block.func_203417_a(BlockTags.field_205599_H) || block.func_203417_a(Tags.Blocks.GRAVEL) || block.func_203417_a(Tags.Blocks.DIRT)) {
            return true;
        }
        if (block.func_203417_a(LOTRTags.Blocks.MORDOR_PLANT_SURFACES)) {
            return true;
        }
        return block == Blocks.field_150348_b && recursion <= 1 && LOTRFeatures.isSurfaceBlock(world, pos.func_177977_b(), recursion + 1);
    }

    public static <T> BlockStateProvider deserializeBlockProvider(Dynamic<T> dyn, String key) {
        BlockStateProviderType blockProvType = (BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)dyn.get(key).get("type").asString().orElseThrow(RuntimeException::new)));
        BlockStateProvider blockProv = blockProvType.func_227399_a_(dyn.get(key).orElseEmptyMap());
        return blockProv;
    }

    public static void setGrassToDirtBelow(IWorld world, BlockPos pos) {
        BlockPos belowPos = pos.func_177977_b();
        world.func_180495_p(belowPos).onPlantGrow(world, belowPos, pos);
    }

    public static void setGrassToDirtBelowDuringChunkGen(IChunk chunk, BlockPos pos) {
        BlockPos belowPos = pos.func_177977_b();
        if (chunk.func_180495_p(belowPos).func_203425_a(Tags.Blocks.DIRT)) {
            chunk.func_177436_a(belowPos, Blocks.field_150346_d.func_176223_P(), false);
        }
    }

    public static BlockState getBlockStateInContext(BlockState state, IWorld world, BlockPos pos) {
        return Block.func_199770_b((BlockState)state, (IWorld)world, (BlockPos)pos);
    }
}

