/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.function.IntToDoubleFunction;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.WaterLatitudeSettings;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class LatitudeBasedFeatureConfig
implements IFeatureConfig {
    public final ConfiguredFeature<?, ?> feature;
    public final LatitudeConfiguration latitudeConfig;

    public LatitudeBasedFeatureConfig(ConfiguredFeature cf, LatitudeConfiguration lat) {
        this.feature = cf;
        this.latitudeConfig = lat;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("feature"), (Object)this.feature.func_222735_a(ops).getValue(), (Object)ops.createString("latitude_type"), (Object)ops.createString(this.latitudeConfig.type.codeName()), (Object)ops.createString("invert"), (Object)ops.createBoolean(this.latitudeConfig.invert), (Object)ops.createString("min"), (Object)ops.createFloat(this.latitudeConfig.min), (Object)ops.createString("max"), (Object)ops.createFloat(this.latitudeConfig.max))));
    }

    public static <T> LatitudeBasedFeatureConfig deserialize(Dynamic<T> dyn) {
        ConfiguredFeature feature = ConfiguredFeature.func_222736_a((Dynamic)dyn.get("feature").orElseEmptyMap());
        LatitudeValuesType latType = LatitudeValuesType.forCode(dyn.get("latitude_type").asString(""));
        boolean invert = dyn.get("invert").asBoolean(false);
        float min = dyn.get("min").asFloat(0.0f);
        float max = dyn.get("max").asFloat(1.0f);
        LatitudeConfiguration latConfig = LatitudeConfiguration.of(latType, invert).min(min).max(max);
        return new LatitudeBasedFeatureConfig(feature, latConfig);
    }

    public static class LatitudeConfiguration {
        public final LatitudeValuesType type;
        public final boolean invert;
        public final float min;
        public final float max;

        private LatitudeConfiguration(LatitudeValuesType type, boolean invert, float min, float max) {
            this.type = type;
            this.invert = invert;
            this.min = min;
            this.max = max;
        }

        public static LatitudeConfiguration of(LatitudeValuesType type, boolean invert) {
            return new LatitudeConfiguration(type, invert, 0.0f, 1.0f);
        }

        public static LatitudeConfiguration of(LatitudeValuesType type) {
            return LatitudeConfiguration.of(type, false);
        }

        public static LatitudeConfiguration ofInverted(LatitudeValuesType type) {
            return LatitudeConfiguration.of(type, true);
        }

        public LatitudeConfiguration min(float newMin) {
            return new LatitudeConfiguration(this.type, this.invert, newMin, this.max);
        }

        public LatitudeConfiguration max(float newMax) {
            return new LatitudeConfiguration(this.type, this.invert, this.min, newMax);
        }
    }

    public static enum LatitudeValuesType {
        ICE("ice", z -> LatitudeValuesType.waterSettings().getIceStartToFullProgress(z)),
        SAND("sand", z -> LatitudeValuesType.waterSettings().getSandyStartToFullProgress(z)),
        CORAL("coral", z -> LatitudeValuesType.waterSettings().getCoralStartToFullProgress(z));

        private final String code;
        private final IntToDoubleFunction zProgressGetter;

        private LatitudeValuesType(String s, IntToDoubleFunction zProgress) {
            this.code = s;
            this.zProgressGetter = zProgress;
        }

        public String codeName() {
            return this.code;
        }

        private static WaterLatitudeSettings waterSettings() {
            return MapSettingsManager.serverInstance().getCurrentLoadedMap().getWaterLatitudes();
        }

        public double getLatitudeProgress(int z) {
            return this.zProgressGetter.applyAsDouble(z);
        }

        public static LatitudeValuesType forCode(String code) {
            for (LatitudeValuesType lats : LatitudeValuesType.values()) {
                if (!lats.codeName().equals(code)) continue;
                return lats;
            }
            return null;
        }
    }
}

