/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import lotr.common.block.MirkOakLeavesBlock;
import lotr.common.world.gen.feature.ExtendedTreeConfig;
import lotr.common.world.gen.feature.ExtendedTreeFeature;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;

public class MirkOakTreeFeature
extends ExtendedTreeFeature<ExtendedTreeConfig> {
    private boolean isDead = false;
    private int trunkWidth = 0;

    public MirkOakTreeFeature(Function<Dynamic<?>, ? extends ExtendedTreeConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> trunk, Set<BlockPos> leaves, MutableBoundingBox bb, ExtendedTreeConfig config) {
        int maxCheckWidth;
        int leafHeight;
        int trunkHeight = config.field_227371_p_ + rand.nextInt(config.field_227328_b_ + 1) + rand.nextInt(config.field_227329_c_ + 1);
        Optional canGrow = this.func_227212_a_(world, trunkHeight, leafHeight = config.field_227330_d_ >= 0 ? config.field_227330_d_ + rand.nextInt(config.field_227331_f_ + 1) : trunkHeight - (config.field_227334_i_ + rand.nextInt(config.field_227335_j_ + 1)), maxCheckWidth = config.field_227327_a_.func_225573_a_(rand, leafHeight, trunkHeight, (TreeFeatureConfig)config), pos, config);
        if (!canGrow.isPresent()) {
            return false;
        }
        BlockPos growPos = (BlockPos)canGrow.get();
        this.setDirtAt(world, growPos.func_177977_b(), growPos);
        for (int y = 0; y < trunkHeight; ++y) {
            this.func_227216_a_(world, rand, growPos.func_177981_b(y), trunk, bb, (BaseTreeFeatureConfig)config);
        }
        this.growLeafCanopy(world, rand, pos.func_177981_b(trunkHeight - 1), trunk, leaves, bb, config);
        boolean hasRoots = true;
        if (hasRoots) {
            int roots = 4 + rand.nextInt(5 * this.trunkWidth + 1);
            for (int l = 0; l < roots; ++l) {
                BlockPos.Mutable rootPos = new BlockPos.Mutable(growPos).func_189534_c(Direction.UP, 1 + rand.nextInt(this.trunkWidth * 2 + 1));
                int rootLength = 4 + rand.nextInt(4);
                Direction rootDir = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                rootPos.func_189534_c(rootDir, this.trunkWidth + 1);
                this.growRootsDownBranchingOut(world, rand, rootPos, rootLength, rootDir, 3, trunk, bb, config);
            }
        }
        if (world instanceof IWorld) {
            IWorld iworld = (IWorld)world;
            for (BlockPos leavesPos : leaves) {
                BlockState leavesState = iworld.func_180495_p(leavesPos);
                if (!(leavesState.func_177230_c() instanceof MirkOakLeavesBlock)) continue;
                BlockPos belowLeavesPos = leavesPos.func_177977_b();
                leavesState = leavesState.func_196956_a(Direction.DOWN, iworld.func_180495_p(belowLeavesPos), iworld, leavesPos, belowLeavesPos);
                iworld.func_180501_a(leavesPos, leavesState, 3);
            }
        }
        return true;
    }

    private void growLeafCanopy(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> trunk, Set<BlockPos> leaves, MutableBoundingBox bb, ExtendedTreeConfig config) {
        int y;
        int leafStart = 2;
        int leafTop = leafStart + 3;
        int maxRange = 3 + rand.nextInt(2);
        if (!this.isDead) {
            BlockPos.Mutable movingPos = new BlockPos.Mutable();
            for (y = leafStart; y <= leafTop; ++y) {
                int dy = y - leafTop;
                int leafRange = maxRange - dy;
                int leafRangeSq = leafRange * leafRange;
                for (int x = -leafRange; x <= leafRange; ++x) {
                    for (int z = -leafRange; z <= leafRange; ++z) {
                        boolean grow;
                        movingPos.func_189533_g((Vec3i)pos).func_196234_d(x, y, z);
                        int dist = x * x + z * z;
                        boolean bl = grow = dist < leafRangeSq;
                        if (Math.abs(x) == leafRange - 1 || Math.abs(z) == leafRange - 1) {
                            grow &= rand.nextInt(4) > 0;
                        }
                        if (!grow) continue;
                        int leavesBelow = 0;
                        if (config.isMirky && y == leafStart && Math.abs(x) <= maxRange && Math.abs(z) <= maxRange && rand.nextInt(3) == 0) {
                            ++leavesBelow;
                        }
                        for (int y1 = dy; y1 >= dy - leavesBelow; --y1) {
                            movingPos.func_189536_c(Direction.DOWN);
                            if (!this.canLeavesReplace(world, (BlockPos)movingPos, config)) continue;
                            this.func_227219_b_(world, rand, (BlockPos)movingPos, leaves, bb, (BaseTreeFeatureConfig)config);
                        }
                    }
                }
            }
        }
        BlockPos.Mutable woodPos = new BlockPos.Mutable();
        for (y = 0; y <= 2; ++y) {
            for (int x = -maxRange; x <= maxRange; ++x) {
                for (int z = -maxRange; z <= maxRange; ++z) {
                    woodPos.func_189533_g((Vec3i)pos).func_196234_d(x, y, z);
                    int xa = Math.abs(x);
                    int za = Math.abs(z);
                    if (!(xa == 0 && za == 0 || xa == za && xa == y) && (xa != 0 && za != 0 || xa == za || xa != y + 1 && za != y + 1)) continue;
                    this.placeWood(world, rand, (BlockPos)woodPos, trunk, bb, config, Direction.Axis.Y);
                }
            }
        }
    }
}

