/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import lotr.common.init.LOTRTags;
import lotr.common.world.gen.feature.MordorMossFeatureConfig;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class MordorMossFeature
extends Feature<MordorMossFeatureConfig> {
    public MordorMossFeature(Function<Dynamic<?>, ? extends MordorMossFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, MordorMossFeatureConfig config) {
        int numberOfMoss = MathHelper.func_76136_a((Random)rand, (int)config.minSize, (int)config.maxSize);
        float randAngle = rand.nextFloat() * (float)Math.PI;
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        int y = pos.func_177956_o();
        BlockPos.Mutable movingPos = new BlockPos.Mutable(pos);
        double d = (float)(x + 8) + MathHelper.func_76126_a((float)randAngle) * (float)numberOfMoss / 8.0f;
        double d1 = (float)(x + 8) - MathHelper.func_76126_a((float)randAngle) * (float)numberOfMoss / 8.0f;
        double d2 = (float)(z + 8) + MathHelper.func_76134_b((float)randAngle) * (float)numberOfMoss / 8.0f;
        double d3 = (float)(z + 8) - MathHelper.func_76134_b((float)randAngle) * (float)numberOfMoss / 8.0f;
        for (int l = 0; l <= numberOfMoss; ++l) {
            double d5 = d + (d1 - d) * (double)l / (double)numberOfMoss;
            double d6 = d2 + (d3 - d2) * (double)l / (double)numberOfMoss;
            double d7 = rand.nextDouble() * (double)numberOfMoss / 16.0;
            double d8 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)numberOfMoss)) + 1.0f) * d7 + 1.0;
            int i1 = MathHelper.func_76128_c((double)(d5 - d8 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d6 - d8 / 2.0));
            int i2 = MathHelper.func_76128_c((double)(d5 + d8 / 2.0));
            int k2 = MathHelper.func_76128_c((double)(d6 + d8 / 2.0));
            for (int i3 = i1; i3 <= i2; ++i3) {
                double d9 = ((double)i3 + 0.5 - d5) / (d8 / 2.0);
                if (!(d9 * d9 < 1.0)) continue;
                for (int k3 = k1; k3 <= k2; ++k3) {
                    double d10;
                    int j1 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, i3, k3);
                    if (j1 != y || !(d9 * d9 + (d10 = ((double)k3 + 0.5 - d6) / (d8 / 2.0)) * d10 < 1.0)) continue;
                    movingPos.func_181079_c(i3, j1, k3);
                    BlockPos below = movingPos.func_177977_b();
                    if (!world.func_175623_d((BlockPos)movingPos) || !world.func_180495_p(below).func_203425_a(LOTRTags.Blocks.MORDOR_PLANT_SURFACES)) continue;
                    world.func_180501_a((BlockPos)movingPos, config.blockState, 2);
                    world.func_180501_a(below, world.func_180495_p(below).func_196956_a(Direction.UP, config.blockState, world, below, (BlockPos)movingPos), 2);
                }
            }
        }
        return true;
    }
}

