/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import lotr.common.world.gen.feature.LOTRFeatures;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class ReedsFeatureConfig
implements IFeatureConfig {
    public final BlockStateProvider blockProvider;
    public final int tries;
    public final int xspread;
    public final int yspread;
    public final int zspread;
    public final float fullyGrownChance;

    public ReedsFeatureConfig(BlockStateProvider blp, int t, int x, int y, int z, float fullChance) {
        this.blockProvider = blp;
        this.tries = t;
        this.xspread = x;
        this.yspread = y;
        this.zspread = z;
        this.fullyGrownChance = fullChance;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("block_provider"), this.blockProvider.func_218175_a(ops)).put(ops.createString("tries"), ops.createInt(this.tries)).put(ops.createString("xspread"), ops.createInt(this.xspread)).put(ops.createString("yspread"), ops.createInt(this.yspread)).put(ops.createString("zspread"), ops.createInt(this.zspread)).put(ops.createString("fully_grown_chance"), ops.createFloat(this.fullyGrownChance));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    public static <T> ReedsFeatureConfig deserialize(Dynamic<T> dyn) {
        BlockStateProvider blockProv = LOTRFeatures.deserializeBlockProvider(dyn, "block_provider");
        int tries = dyn.get("tries").asInt(0);
        int xspread = dyn.get("xspread").asInt(0);
        int yspread = dyn.get("yspread").asInt(0);
        int zspread = dyn.get("zspread").asInt(0);
        float fullyGrownChance = dyn.get("fully_grown_chance").asFloat(0.5f);
        return new ReedsFeatureConfig(blockProv, tries, xspread, yspread, zspread, fullyGrownChance);
    }
}

