/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lotr.common.LOTRLog;
import lotr.common.world.gen.feature.WeightedFeature;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class WeightedRandomFeatureConfig
implements IFeatureConfig {
    public final List<WeightedFeature<?>> weightedFeatures;
    private int totalWeight;

    public static WeightedRandomFeatureConfig fromEntries(Object ... entries) {
        try {
            ArrayList<WeightedFeature<ConfiguredFeature>> tempList = new ArrayList<WeightedFeature<ConfiguredFeature>>();
            for (int i = 0; i < entries.length; i += 2) {
                ConfiguredFeature feature = (ConfiguredFeature)entries[i];
                int weight = (Integer)entries[i + 1];
                WeightedFeature<ConfiguredFeature> wf = WeightedFeature.make(feature, weight);
                tempList.add(wf);
            }
            return new WeightedRandomFeatureConfig((List<WeightedFeature<?>>)ImmutableList.copyOf(tempList));
        }
        catch (ArrayIndexOutOfBoundsException | ClassCastException e) {
            throw new IllegalArgumentException("Error adding biome trees! A list of (tree1, weight1), (tree2, weight2)... is required", e);
        }
    }

    public WeightedRandomFeatureConfig(List<WeightedFeature<?>> features) {
        this.weightedFeatures = features;
        this.updateTotalWeight();
    }

    private void updateTotalWeight() {
        this.totalWeight = 0;
        this.weightedFeatures.stream().forEach(wf -> this.totalWeight += wf.weight);
    }

    private int getTotalWeight() {
        return this.totalWeight;
    }

    public <FC extends IFeatureConfig, F extends Feature<FC>> ConfiguredFeature<FC, F> getRandomFeature(Random rand) {
        int totalWeight = this.getTotalWeight();
        int chosenWeight = rand.nextInt(totalWeight);
        WeightedFeature<?> selected = null;
        for (WeightedFeature<?> weightedFeature : this.weightedFeatures) {
            float featureWeight = weightedFeature.weight;
            if ((float)chosenWeight < featureWeight) {
                selected = weightedFeature;
                break;
            }
            chosenWeight = (int)((float)chosenWeight - featureWeight);
        }
        if (selected == null) {
            LOTRLog.error("WeightedRandomFeature error: total weight = %d, chosen weight = %d, but selected feature == null", totalWeight, chosenWeight);
        }
        return selected.feature;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        Object t = ops.createList(this.weightedFeatures.stream().map(wf -> wf.serialize(ops).getValue()));
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("features"), (Object)t)));
    }

    public static <T> WeightedRandomFeatureConfig deserialize(Dynamic<T> dyn) {
        List list = dyn.get("features").asList(WeightedFeature::deserialize);
        return new WeightedRandomFeatureConfig(list);
    }
}

