/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.layer;

import java.util.function.LongFunction;
import lotr.common.init.LOTRWorldTypes;
import lotr.common.world.biome.provider.MiddleEarthBiomeProviderSettings;
import lotr.common.world.gen.MiddleEarthGenSettings;
import lotr.common.world.gen.layer.BiomeSubtypesLayer;
import lotr.common.world.gen.layer.ClassicBiomeLayer;
import lotr.common.world.gen.layer.ClassicRemoveSeaAtOriginLayer;
import lotr.common.world.gen.layer.ClassicSeedSeasLayer;
import lotr.common.world.gen.layer.MEAddIslandsLayer;
import lotr.common.world.gen.layer.MEAddRiversLayer;
import lotr.common.world.gen.layer.MERiverLayer;
import lotr.common.world.gen.layer.MESeedRiversLayer;
import lotr.common.world.gen.layer.MEShoreLayers;
import lotr.common.world.gen.layer.MiddleEarthMapLayer;
import lotr.common.world.gen.layer.SeedBiomeSubtypesLayer;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapSettingsManager;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;

public class MiddleEarthWorldLayers {
    public static final int MIN_SCALE_POWER = 2;
    public static final int MAX_SCALE_POWER = 10;

    public static Layer create(MiddleEarthBiomeProviderSettings biomeSettings, long worldSeed, WorldType worldType, MiddleEarthGenSettings genSettings) {
        int maxCacheSize = 25;
        IAreaFactory areaFactory = MiddleEarthWorldLayers.createLayers(biomeSettings, worldType, genSettings, val -> new LazyAreaLayerContext(maxCacheSize, worldSeed, val));
        return new Layer(areaFactory);
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> createLayers(MiddleEarthBiomeProviderSettings biomeSettings, WorldType worldType, MiddleEarthGenSettings genSettings, LongFunction<C> longFunc) {
        int numZooms;
        boolean classic = worldType == LOTRWorldTypes.MIDDLE_EARTH_CLASSIC;
        MapSettings mapSettings = MapSettingsManager.serverInstance().getCurrentLoadedMap();
        int mapScale = mapSettings.getScalePower();
        int classicBiomeScale = genSettings.getClassicBiomeSize();
        boolean proceduralRivers = mapSettings.getProceduralRivers();
        int riverScale = genSettings.getRiverSize();
        IAreaFactory riverLayer = MESeedRiversLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)longFunc.apply(100L));
        riverLayer = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)riverLayer, (int)(2 + riverScale), longFunc);
        riverLayer = MERiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)longFunc.apply(1L), riverLayer);
        riverLayer = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)longFunc.apply(1000L), riverLayer);
        IAreaFactory subBiomesLayer = SeedBiomeSubtypesLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)longFunc.apply(3000L));
        subBiomesLayer = LayerUtil.func_202829_a((long)3000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)subBiomesLayer, (int)2, longFunc);
        IAreaFactory biomeLayer = null;
        if (classic) {
            IAreaFactory seaLayer = ClassicSeedSeasLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)longFunc.apply(2012L));
            seaLayer = LayerUtil.func_202829_a((long)200L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)seaLayer, (int)3, longFunc);
            seaLayer = ClassicRemoveSeaAtOriginLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)longFunc.apply(300L), seaLayer);
            biomeLayer = new ClassicBiomeLayer(biomeSettings, genSettings).func_202713_a((IExtendedNoiseRandom)longFunc.apply(2013L), seaLayer);
            biomeLayer = LayerUtil.func_202829_a((long)300L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)biomeLayer, (int)2, longFunc);
        } else {
            biomeLayer = MiddleEarthMapLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)longFunc.apply(1954L));
        }
        biomeLayer = BiomeSubtypesLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)longFunc.apply(1000L), biomeLayer, subBiomesLayer);
        biomeLayer = new MEAddIslandsLayer(400).func_202713_a((IExtendedNoiseRandom)longFunc.apply(400L), biomeLayer);
        int curZoom = 0;
        int n = numZooms = classic ? classicBiomeScale : mapScale - 2;
        while (true) {
            if (curZoom == Math.max(0, numZooms - 5)) {
                // empty if block
            }
            if (curZoom == Math.max(0, numZooms - 4)) {
                biomeLayer = new MEAddIslandsLayer(400).func_202713_a((IExtendedNoiseRandom)longFunc.apply(300L), biomeLayer);
                biomeLayer = MEShoreLayers.ForMainland.INSTANCE.func_202713_a((IExtendedNoiseRandom)longFunc.apply(1000L), biomeLayer);
            }
            if (curZoom == Math.max(0, numZooms - 3)) {
                biomeLayer = MEShoreLayers.ForIsland.INSTANCE.func_202713_a((IExtendedNoiseRandom)longFunc.apply(900L), biomeLayer);
            }
            if (curZoom == Math.max(0, numZooms - 2)) {
                // empty if block
            }
            if (curZoom >= numZooms) break;
            biomeLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)longFunc.apply(1000L + (long)curZoom), biomeLayer);
            ++curZoom;
        }
        biomeLayer = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)longFunc.apply(1000L), biomeLayer);
        if (proceduralRivers) {
            biomeLayer = MEAddRiversLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)longFunc.apply(100L), biomeLayer, riverLayer);
        }
        return biomeLayer;
    }
}

