/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.placement;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lotr.common.world.gen.placement.AtSurfaceLayerLimitedWithExtraConfig;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.placement.Placement;

public class AtSurfaceLayerLimitedWithExtra
extends Placement<AtSurfaceLayerLimitedWithExtraConfig> {
    public AtSurfaceLayerLimitedWithExtra(Function<Dynamic<?>, ? extends AtSurfaceLayerLimitedWithExtraConfig> func) {
        super(func);
    }

    public Stream<BlockPos> getPositions(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, AtSurfaceLayerLimitedWithExtraConfig config, BlockPos pos) {
        int i = config.count;
        if (rand.nextFloat() < config.extraChance) {
            i += config.extraCount;
        }
        return IntStream.range(0, i).mapToObj(index -> {
            int x = rand.nextInt(16) + pos.func_177958_n();
            int z = rand.nextInt(16) + pos.func_177952_p();
            int y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, x, z);
            return new BlockPos(x, y, z);
        }).filter(aPos -> {
            if (config.isLayerUpperLimit) {
                return aPos.func_177956_o() <= config.layerLimit;
            }
            return aPos.func_177956_o() >= config.layerLimit;
        });
    }
}

