/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.placement;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import lotr.common.world.biome.TreeCluster;
import net.minecraft.world.gen.placement.IPlacementConfig;

public class TreeClustersConfig
implements IPlacementConfig {
    public final int count;
    public final float extraChance;
    public final int extraCount;
    public final int clusterScale;
    public final int clusterChance;
    public final int clusterExtraCount;
    public final int clusterRandomExtraCount;
    public final int layerLimit;
    public final boolean isLayerUpperLimit;

    private TreeClustersConfig(Builder builder) {
        this.count = builder.count;
        this.extraChance = builder.extraChance;
        this.extraCount = builder.extraCount;
        this.clusterScale = builder.clusterScale;
        this.clusterChance = builder.clusterChance;
        this.clusterExtraCount = builder.clusterExtraCount;
        this.clusterRandomExtraCount = builder.clusterRandomExtraCount;
        this.layerLimit = builder.layerLimit;
        this.isLayerUpperLimit = builder.isLayerUpperLimit;
    }

    public boolean hasLayerLimit() {
        return this.layerLimit >= 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> Dynamic<T> func_214719_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("count"), ops.createInt(this.count)).put(ops.createString("extra_chance"), ops.createFloat(this.extraChance)).put(ops.createString("extra_count"), ops.createInt(this.extraCount)).put(ops.createString("cluster_scale"), ops.createInt(this.clusterScale)).put(ops.createString("cluster_chance"), ops.createInt(this.clusterChance)).put(ops.createString("cluster_extra_count"), ops.createInt(this.clusterExtraCount)).put(ops.createString("cluster_random_extra_count"), ops.createInt(this.clusterRandomExtraCount)).put(ops.createString("layer_limit"), ops.createInt(this.layerLimit)).put(ops.createString("is_layer_upper_limit"), ops.createBoolean(this.isLayerUpperLimit));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    public static TreeClustersConfig deserialize(Dynamic<?> dyn) {
        int count = dyn.get("count").asInt(0);
        float extraChance = dyn.get("extra_chance").asFloat(0.1f);
        int extraCount = dyn.get("extra_count").asInt(1);
        int clusterScale = dyn.get("cluster_scale").asInt(0);
        int clusterChance = dyn.get("cluster_chance").asInt(-1);
        int clusterExtraCount = dyn.get("cluster_extra_count").asInt(6);
        int clusterRandomExtraCount = dyn.get("cluster_random_extra_count").asInt(4);
        int layerLimit = dyn.get("layer_limit").asInt(-1);
        boolean isLayerUpperLimit = dyn.get("is_layer_upper_limit").asBoolean(false);
        return TreeClustersConfig.builder().count(count).extraChance(extraChance).extraCount(extraCount).cluster(TreeCluster.of(clusterScale, clusterChance)).clusterExtraCount(clusterExtraCount).clusterRandomExtraCount(clusterRandomExtraCount).layerLimit(layerLimit, isLayerUpperLimit).build();
    }

    public static class Builder {
        private int count = 0;
        private float extraChance = 0.1f;
        private int extraCount = 1;
        private int clusterScale = 0;
        private int clusterChance = -1;
        private int clusterExtraCount = 6;
        private int clusterRandomExtraCount = 4;
        private int layerLimit = -1;
        private boolean isLayerUpperLimit = false;

        private Builder() {
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        public Builder extraChance(float extraChance) {
            this.extraChance = extraChance;
            return this;
        }

        public Builder extraCount(int extraCount) {
            this.extraCount = extraCount;
            return this;
        }

        public Builder cluster(TreeCluster cluster) {
            this.clusterScale = cluster.scale;
            this.clusterChance = cluster.chance;
            return this;
        }

        public Builder clusterExtraCount(int clusterExtraCount) {
            this.clusterExtraCount = clusterExtraCount;
            return this;
        }

        public Builder clusterRandomExtraCount(int clusterRandomExtraCount) {
            this.clusterRandomExtraCount = clusterRandomExtraCount;
            return this;
        }

        public Builder layerLimit(int layerLimit, boolean isLayerUpperLimit) {
            this.layerLimit = layerLimit;
            this.isLayerUpperLimit = isLayerUpperLimit;
            return this;
        }

        public TreeClustersConfig build() {
            return new TreeClustersConfig(this);
        }
    }
}

