/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import lotr.common.world.gen.tree.LOTRFoliagePlacers;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;

public class AspenFoliagePlacer
extends FoliagePlacer {
    public AspenFoliagePlacer(int r, int rRand) {
        super(r, rRand, LOTRFoliagePlacers.ASPEN_FOLIAGE);
    }

    public <T> AspenFoliagePlacer(Dynamic<T> dyn) {
        this(dyn.get("radius").asInt(0), dyn.get("radius_random").asInt(0));
    }

    public void func_225571_a_(IWorldGenerationReader world, Random rand, TreeFeatureConfig config, int leafTop, int leafBottom, int maxLeafWidth, BlockPos base, Set<BlockPos> leaves) {
        for (int y = leafTop; y >= leafBottom; --y) {
            int layerWidth = maxLeafWidth;
            if (y >= leafTop - 1) {
                layerWidth = maxLeafWidth - 2;
            } else if (y >= leafTop - 3 || y <= leafBottom + 1 || rand.nextInt(4) == 0) {
                layerWidth = maxLeafWidth - 1;
            }
            int branches = 4 + rand.nextInt(5);
            for (int b = 0; b < branches; ++b) {
                BlockPos.Mutable movingPos = new BlockPos.Mutable(base).func_196234_d(0, y, 0);
                int origX = movingPos.func_177958_n();
                int origZ = movingPos.func_177952_p();
                int length = 4 + rand.nextInt(8);
                for (int l = 0; l < length && Math.abs(origX - movingPos.func_177958_n()) <= layerWidth && Math.abs(origZ - movingPos.func_177952_p()) <= layerWidth; ++l) {
                    this.func_227385_a_(world, rand, (BlockPos)movingPos, config, leaves);
                    Direction randDir = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                    movingPos.func_189536_c(randDir);
                }
            }
        }
    }

    public int func_225573_a_(Random rand, int leafBottom, int leafTop, TreeFeatureConfig config) {
        return this.field_227381_a_ + rand.nextInt(this.field_227382_b_ + 1);
    }

    protected boolean func_225572_a_(Random rand, int leafTopY, int x, int currentLayerY, int z, int layerWidth) {
        return false;
    }

    public int func_225570_a_(int leafBottom, int leafTop, int maxLeafWidth, int y) {
        return y <= leafBottom ? 0 : maxLeafWidth;
    }
}

