/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import lotr.common.world.gen.tree.LOTRFoliagePlacers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;

public class FirFoliagePlacer
extends FoliagePlacer {
    public FirFoliagePlacer(int r, int rRand) {
        super(r, rRand, LOTRFoliagePlacers.FIR_FOLIAGE);
    }

    public <T> FirFoliagePlacer(Dynamic<T> dyn) {
        this(dyn.get("radius").asInt(0), dyn.get("radius_random").asInt(0));
    }

    public void func_225571_a_(IWorldGenerationReader world, Random rand, TreeFeatureConfig config, int leafTop, int leafBottom, int maxLeafWidth, BlockPos base, Set<BlockPos> leaves) {
        leafBottom = Math.max(leafBottom, 1);
        this.func_227384_a_(world, rand, config, leafTop, base, leafTop, 0, leaves);
        this.func_227384_a_(world, rand, config, leafTop, base, leafTop - 1, 0, leaves);
        int topY = leafTop - 2;
        int leafLayers = topY - leafBottom + 1;
        int sections = maxLeafWidth;
        int sectionHeight = MathHelper.func_76123_f((float)((float)leafLayers / (float)sections));
        int curSectionWidth = 1;
        int curSectionHeight = 0;
        for (int y = topY; y >= leafBottom; --y) {
            this.func_227384_a_(world, rand, config, leafTop, base, y, curSectionWidth, leaves);
            if (++curSectionHeight < sectionHeight) continue;
            ++curSectionWidth;
            curSectionHeight = 0;
        }
    }

    public int func_225573_a_(Random rand, int leafBottom, int leafTop, TreeFeatureConfig config) {
        return this.field_227381_a_ + rand.nextInt(this.field_227382_b_ + 1);
    }

    protected boolean func_225572_a_(Random rand, int leafTopY, int x, int currentLayerY, int z, int layerWidth) {
        int taxicab = Math.abs(x) + Math.abs(z);
        return taxicab > layerWidth;
    }

    public int func_225570_a_(int leafBottom, int leafTop, int maxLeafWidth, int y) {
        return y <= leafBottom ? 0 : maxLeafWidth;
    }
}

