/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.Dynamic;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Function;
import lotr.common.util.LOTRUtil;
import lotr.common.world.gen.tree.MirkOakWebsDecorator;
import lotr.common.world.gen.tree.PineBranchDecorator;
import lotr.common.world.gen.tree.PineStripDecorator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;

public class LOTRTreeDecorators {
    public static TreeDecoratorType<PineBranchDecorator> PINE_BRANCH;
    public static TreeDecoratorType<PineStripDecorator> PINE_STRIP;
    public static TreeDecoratorType<MirkOakWebsDecorator> MIRK_OAK_WEBS;

    public static void register() {
        PINE_BRANCH = LOTRTreeDecorators.registerModded("pine_branch", PineBranchDecorator::new);
        PINE_STRIP = LOTRTreeDecorators.registerModded("pine_strip", PineStripDecorator::new);
        MIRK_OAK_WEBS = LOTRTreeDecorators.registerModded("mirk_oak_webs", MirkOakWebsDecorator::new);
    }

    private static <P extends TreeDecorator> TreeDecoratorType<P> registerModded(String name, Function<Dynamic<?>, P> func) {
        try {
            Constructor constr = TreeDecoratorType.class.getDeclaredConstructor(Function.class);
            LOTRUtil.unlockConstructor(constr);
            TreeDecoratorType type = (TreeDecoratorType)constr.newInstance(func);
            return (TreeDecoratorType)Registry.func_218322_a((Registry)Registry.field_229390_w_, (ResourceLocation)new ResourceLocation("lotr", name), (Object)type);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not create custom TreeDecoratorType");
        }
    }
}

