/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import lotr.common.block.HangingWebBlock;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.MirkwoodBiome;
import lotr.common.world.gen.tree.LOTRTreeDecorators;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.treedecorator.TreeDecorator;

public class MirkOakWebsDecorator
extends TreeDecorator {
    private final boolean mirkwoodOnly;
    private final float prob;
    private final float perBlockChance;
    private final float doubleWebChance;

    public MirkOakWebsDecorator(boolean flag, float f, float perBlock, float doubleWeb) {
        super(LOTRTreeDecorators.MIRK_OAK_WEBS);
        this.mirkwoodOnly = flag;
        this.prob = f;
        this.perBlockChance = perBlock;
        this.doubleWebChance = doubleWeb;
    }

    public <T> MirkOakWebsDecorator(Dynamic<T> dyn) {
        this(dyn.get("mirkwood_only").asBoolean(false), dyn.get("probability").asFloat(0.0f), dyn.get("per_block_chance").asFloat(0.0f), dyn.get("double_web_chance").asFloat(0.0f));
    }

    public void func_225576_a_(IWorld world, Random rand, List<BlockPos> trunk, List<BlockPos> leaves, Set<BlockPos> decoSet, MutableBoundingBox bb) {
        boolean doDecorate;
        boolean bl = doDecorate = rand.nextFloat() < this.prob;
        if (doDecorate && this.mirkwoodOnly) {
            BlockPos centralPos = new BlockPos((bb.field_78897_a + bb.field_78893_d) / 2, bb.field_78895_b, (bb.field_78896_c + bb.field_78892_f) / 2);
            doDecorate &= world.func_226691_t_(centralPos) instanceof MirkwoodBiome;
        }
        if (doDecorate) {
            for (BlockPos leavesPos : leaves) {
                boolean placeDouble;
                BlockPos webPos;
                if (!(rand.nextFloat() < this.perBlockChance) || !world.func_175623_d(webPos = leavesPos.func_177977_b())) continue;
                BlockState baseWebState = ((Block)LOTRBlocks.HANGING_WEB.get()).func_176223_P();
                BlockPos belowWebPos = webPos.func_177977_b();
                boolean bl2 = placeDouble = rand.nextFloat() < this.doubleWebChance && world.func_175623_d(belowWebPos);
                if (placeDouble) {
                    BlockState topWebState = (BlockState)baseWebState.func_206870_a(HangingWebBlock.WEB_TYPE, (Comparable)((Object)HangingWebBlock.Type.DOUBLE_TOP));
                    BlockState bottomWebState = (BlockState)baseWebState.func_206870_a(HangingWebBlock.WEB_TYPE, (Comparable)((Object)HangingWebBlock.Type.DOUBLE_BOTTOM));
                    this.func_227423_a_((IWorldWriter)world, webPos, topWebState, decoSet, bb);
                    this.func_227423_a_((IWorldWriter)world, belowWebPos, bottomWebState, decoSet, bb);
                } else {
                    BlockState webState = (BlockState)baseWebState.func_206870_a(HangingWebBlock.WEB_TYPE, (Comparable)((Object)HangingWebBlock.Type.SINGLE));
                    this.func_227423_a_((IWorldWriter)world, webPos, webState, decoSet, bb);
                }
                world.func_180495_p(webPos).func_196946_a(world, webPos, 3);
            }
        }
    }

    public <T> T func_218175_a(DynamicOps<T> ops) {
        return (T)new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("type"), (Object)ops.createString(Registry.field_229390_w_.func_177774_c((Object)this.field_227422_a_).toString()), (Object)ops.createString("mirkwood_only"), (Object)ops.createBoolean(this.mirkwoodOnly), (Object)ops.createString("probability"), (Object)ops.createFloat(this.prob), (Object)ops.createString("per_block_chance"), (Object)ops.createFloat(this.perBlockChance), (Object)ops.createString("double_web_chance"), (Object)ops.createFloat(this.doubleWebChance)))).getValue();
    }
}

